"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _postcssValueParser = _interopRequireDefault(require("postcss-value-parser"));
var _atRuleParamIndex = _interopRequireDefault(require("../../utils/atRuleParamIndex.js"));
var _declarationValueIndex = _interopRequireDefault(require("../../utils/declarationValueIndex.js"));
var _getDimension2 = _interopRequireDefault(require("../../utils/getDimension.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var ruleName = "unit-case";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expected: function expected(actual, _expected) {
    return "Expected \"".concat(actual, "\" to be \"").concat(_expected, "\"");
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/unit-case/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["lower", "upper"]
    });
    if (!validOptions) {
      return;
    }

    /**
    	 * @template {import('postcss').AtRule | import('postcss').Declaration} T
    	 * @param {T} node
    	 * @param {string} checkedValue
    	 * @param {(node: T) => number} getIndex
    	 * @returns {void}
    	 */
    function check(node, checkedValue, getIndex) {
      /** @type {Array<{ index: number, endIndex: number, message: string }>} */
      var problems = [];

      /**
      	 * @param {import('postcss-value-parser').Node} valueNode
      	 * @returns {boolean}
      	 */
      function processValue(valueNode) {
        var _getDimension = (0, _getDimension2["default"])(valueNode),
          number = _getDimension.number,
          unit = _getDimension.unit;
        if (!number || !unit) {
          return false;
        }
        var expectedUnit = primary === "lower" ? unit.toLowerCase() : unit.toUpperCase();
        if (unit === expectedUnit) {
          return false;
        }
        var index = getIndex(node);
        problems.push({
          index: index + valueNode.sourceIndex + number.length,
          endIndex: index + valueNode.sourceEndIndex,
          message: messages.expected(unit, expectedUnit)
        });
        return true;
      }
      var parsedValue = (0, _postcssValueParser["default"])(checkedValue).walk(function (valueNode) {
        // Ignore wrong units within `url` function
        var needFix = false;
        var value = valueNode.value;
        if (valueNode.type === "function" && value.toLowerCase() === "url") {
          return false;
        }
        if (value.includes("*")) {
          value.split("*").some(function (val) {
            return processValue(_objectSpread(_objectSpread({}, valueNode), {}, {
              sourceIndex: value.indexOf(val) + val.length + 1,
              value: val
            }));
          });
        }
        needFix = processValue(valueNode);
        if (needFix && context.fix) {
          valueNode.value = primary === "lower" ? value.toLowerCase() : value.toUpperCase();
        }
      });
      if (problems.length) {
        if (context.fix) {
          if ("name" in node && node.name === "media") {
            node.params = parsedValue.toString();
          } else if ("value" in node) {
            node.value = parsedValue.toString();
          }
        } else {
          var _iterator = _createForOfIteratorHelper(problems),
            _step;
          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var err = _step.value;
              (0, _report["default"])({
                index: err.index,
                endIndex: err.endIndex,
                message: err.message,
                node: node,
                result: result,
                ruleName: ruleName
              });
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
        }
      }
    }
    root.walkAtRules(function (atRule) {
      if (!/^media$/i.test(atRule.name) && !("variable" in atRule)) {
        return;
      }
      check(atRule, atRule.params, _atRuleParamIndex["default"]);
    });
    root.walkDecls(function (decl) {
      return check(decl, decl.value, _declarationValueIndex["default"]);
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;