"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _declarationValueIndex = _interopRequireDefault(require("../../utils/declarationValueIndex.js"));
var _getDeclarationValue = _interopRequireDefault(require("../../utils/getDeclarationValue.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _setDeclarationValue = _interopRequireDefault(require("../../utils/setDeclarationValue.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _valueListCommaWhitespaceChecker = _interopRequireDefault(require("../valueListCommaWhitespaceChecker.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var ruleName = "value-list-comma-space-after";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedAfter: function expectedAfter() {
    return "Expected single space after \",\"";
  },
  rejectedAfter: function rejectedAfter() {
    return "Unexpected whitespace after \",\"";
  },
  expectedAfterSingleLine: function expectedAfterSingleLine() {
    return "Expected single space after \",\" in a single-line list";
  },
  rejectedAfterSingleLine: function rejectedAfterSingleLine() {
    return "Unexpected whitespace after \",\" in a single-line list";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/value-list-comma-space-after/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  var checker = (0, _whitespaceChecker["default"])("space", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never", "always-single-line", "never-single-line"]
    });
    if (!validOptions) {
      return;
    }

    /** @type {Map<import('postcss').Declaration, number[]> | undefined} */
    var fixData;
    (0, _valueListCommaWhitespaceChecker["default"])({
      root: root,
      result: result,
      locationChecker: checker.after,
      checkedRuleName: ruleName,
      fix: context.fix ? function (declNode, index) {
        var valueIndex = (0, _declarationValueIndex["default"])(declNode);
        if (index <= valueIndex) {
          return false;
        }
        fixData = fixData || new Map();
        var commaIndices = fixData.get(declNode) || [];
        commaIndices.push(index);
        fixData.set(declNode, commaIndices);
        return true;
      } : null
    });
    if (fixData) {
      var _iterator = _createForOfIteratorHelper(fixData.entries()),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _step$value = _slicedToArray(_step.value, 2),
            decl = _step$value[0],
            commaIndices = _step$value[1];
          var _iterator2 = _createForOfIteratorHelper(commaIndices.sort(function (a, b) {
              return b - a;
            })),
            _step2;
          try {
            for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
              var index = _step2.value;
              var value = (0, _getDeclarationValue["default"])(decl);
              var valueIndex = index - (0, _declarationValueIndex["default"])(decl);
              var beforeValue = value.slice(0, valueIndex + 1);
              var afterValue = value.slice(valueIndex + 1);
              if (primary.startsWith("always")) {
                afterValue = afterValue.replace(/^\s*/, " ");
              } else if (primary.startsWith("never")) {
                afterValue = afterValue.replace(/^\s*/, "");
              }
              (0, _setDeclarationValue["default"])(decl, beforeValue + afterValue);
            }
          } catch (err) {
            _iterator2.e(err);
          } finally {
            _iterator2.f();
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;