"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _getDeclarationValue = _interopRequireDefault(require("../../utils/getDeclarationValue.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _setDeclarationValue = _interopRequireDefault(require("../../utils/setDeclarationValue.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _validateTypes = require("../../utils/validateTypes.js");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "value-list-max-empty-lines";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expected: function expected(max) {
    return "Expected no more than ".concat(max, " empty ").concat(max === 1 ? "line" : "lines");
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/value-list-max-empty-lines/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  var maxAdjacentNewlines = primary + 1;
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: _validateTypes.isNumber
    });
    if (!validOptions) {
      return;
    }
    var violatedCRLFNewLinesRegex = new RegExp("(?:\r\n){".concat(maxAdjacentNewlines + 1, ",}"));
    var violatedLFNewLinesRegex = new RegExp("\n{".concat(maxAdjacentNewlines + 1, ",}"));
    var allowedLFNewLinesString = context.fix ? "\n".repeat(maxAdjacentNewlines) : "";
    var allowedCRLFNewLinesString = context.fix ? "\r\n".repeat(maxAdjacentNewlines) : "";
    root.walkDecls(function (decl) {
      var value = (0, _getDeclarationValue["default"])(decl);
      if (context.fix) {
        var newValueString = value.replace(new RegExp(violatedLFNewLinesRegex, "gm"), allowedLFNewLinesString).replace(new RegExp(violatedCRLFNewLinesRegex, "gm"), allowedCRLFNewLinesString);
        (0, _setDeclarationValue["default"])(decl, newValueString);
      } else if (violatedLFNewLinesRegex.test(value) || violatedCRLFNewLinesRegex.test(value)) {
        (0, _report["default"])({
          message: messages.expected(primary),
          node: decl,
          index: 0,
          result: result,
          ruleName: ruleName
        });
      }
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;