"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = valueListCommaWhitespaceChecker;
var _styleSearch = _interopRequireDefault(require("style-search"));
var _isStandardSyntaxDeclaration = _interopRequireDefault(require("../utils/isStandardSyntaxDeclaration.js"));
var _isStandardSyntaxProperty = _interopRequireDefault(require("../utils/isStandardSyntaxProperty.js"));
var _report = _interopRequireDefault(require("../utils/report.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
/**
 * @param {{
 *   root: import('postcss').Root,
 *   result: import('stylelint').PostcssResult,
 *   locationChecker: (opts: { source: string, index: number, err: (msg: string) => void }) => void,
 *   checkedRuleName: string,
 *   fix?: ((node: import('postcss').Declaration, index: number) => boolean) | null,
 *   determineIndex?: (declString: string, match: import('style-search').StyleSearchMatch) => number | false,
 * }} opts
 */
function valueListCommaWhitespaceChecker(opts) {
  opts.root.walkDecls(function (decl) {
    if (!(0, _isStandardSyntaxDeclaration["default"])(decl) || !(0, _isStandardSyntaxProperty["default"])(decl.prop)) {
      return;
    }
    var declString = decl.toString();
    (0, _styleSearch["default"])({
      source: declString,
      target: ",",
      functionArguments: "skip"
    }, function (match) {
      var indexToCheckAfter = opts.determineIndex ? opts.determineIndex(declString, match) : match.startIndex;
      if (indexToCheckAfter === false) {
        return;
      }
      checkComma(declString, indexToCheckAfter, decl);
    });
  });

  /**
   * @param {string} source
   * @param {number} index
   * @param {import('postcss').Declaration} node
   * @returns {void}
   */
  function checkComma(source, index, node) {
    opts.locationChecker({
      source: source,
      index: index,
      err: function err(message) {
        if (opts.fix && opts.fix(node, index)) {
          return;
        }
        (0, _report["default"])({
          message: message,
          node: node,
          index: index,
          result: opts.result,
          ruleName: opts.checkedRuleName
        });
      }
    });
  }
}