"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = addEmptyLineAfter;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
/**
 * Add an empty line after a node. Mutates the node.
 *
 * @template {import('postcss').Rule | import('postcss').AtRule} T
 * @param {T} node
 * @param {string} newline
 * @returns {T}
 */
function addEmptyLineAfter(node, newline) {
  var raws = node.raws;
  if (_typeof(raws.after) !== "string") {
    return node;
  }
  var spaces = raws.after.split(";");
  var after = spaces[spaces.length - 1] || "";
  if (!/\r?\n/.test(after)) {
    raws.after += newline.repeat(2);
  } else {
    raws.after = raws.after.replace(/(\r?\n)/, "".concat(newline, "$1"));
  }
  return node;
}