"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = arrayEqual;
/**
 * Tests if two arrays are equal.
 *
 * @param {unknown} a
 * @param {unknown} b
 * @returns {boolean}
 */
function arrayEqual(a, b) {
  if (!Array.isArray(a) || !Array.isArray(b)) {
    return false;
  }
  if (a.length !== b.length) {
    return false;
  }
  return a.every(function (elem, index) {
    return elem === b[index];
  });
}