"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = beforeBlockString;
var _typeGuards = require("./typeGuards.js");
/**
 * @param {import('postcss').Container} statement
 * @returns {string}
 */
function beforeBlockString(statement) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
      noRawBefore: false
    },
    noRawBefore = _ref.noRawBefore;
  var result = "";
  var before = statement.raws.before || "";
  if (!noRawBefore) {
    result += before;
  }
  if ((0, _typeGuards.isRule)(statement)) {
    result += statement.selector;
  } else if ((0, _typeGuards.isAtRule)(statement)) {
    result += "@".concat(statement.name).concat(statement.raws.afterName || "").concat(statement.params);
  } else {
    return "";
  }
  result += statement.raws.between || "";
  return result;
}