"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = blockString;
var _beforeBlockString = _interopRequireDefault(require("./beforeBlockString.js"));
var _hasBlock = _interopRequireDefault(require("./hasBlock.js"));
var _rawNodeString = _interopRequireDefault(require("./rawNodeString.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
/**
 * Return a CSS statement's block -- the string that starts and `{` and ends with `}`.
 *
 * If the statement has no block (e.g. `@import url(foo.css);`), returns an empty string.
 *
 * @param {import('postcss').Container} statement
 * @returns {string}
 */
function blockString(statement) {
  if (!(0, _hasBlock["default"])(statement)) {
    return "";
  }
  return (0, _rawNodeString["default"])(statement).slice((0, _beforeBlockString["default"])(statement).length);
}