"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = configurationError;
/** @typedef {Error & { code: number }} ConfigurationError */

/**
 * Create configurationError from text and set CLI exit code.
 *
 * @param {string} text
 * @returns {ConfigurationError}
 */
function configurationError(text) {
  var err = /** @type {ConfigurationError} */new Error(text);
  err.code = 78;
  return err;
}