"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = declarationValueIndex;
var _validateTypes = require("./validateTypes.js");
/**
 * Get the index of a declaration's value
 *
 * @param {import('postcss').Declaration} decl
 * @returns {number}
 */
function declarationValueIndex(decl) {
  var raws = decl.raws;
  var prop = raws.prop;
  return [(0, _validateTypes.isObject)(prop) && "prefix" in prop && prop.prefix, (0, _validateTypes.isObject)(prop) && "raw" in prop && prop.raw || decl.prop, (0, _validateTypes.isObject)(prop) && "suffix" in prop && prop.suffix, raws.between || ":", raws.value && "prefix" in raws.value && raws.value.prefix].reduce(function ( /** @type {number} */count, str) {
    if ((0, _validateTypes.isString)(str)) {
      return count + str.length;
    }
    return count;
  }, 0);
}