"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = getDimension;
var _postcssValueParser = _interopRequireDefault(require("postcss-value-parser"));
var _blurInterpolation = _interopRequireDefault(require("./blurInterpolation.js"));
var _isStandardSyntaxValue = _interopRequireDefault(require("./isStandardSyntaxValue.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
/**
 * Get Dimension from value node;
 * `unit` and `number` return null if neither is found
 *
 * @param {import('postcss-value-parser').Node} node
 *
 * @returns {{unit: null, number: null} | valueParser.Dimension}
 */
function getDimension(node) {
  if (!node || !node.value) {
    return {
      unit: null,
      number: null
    };
  }

  // Ignore non-word nodes
  if (node.type !== "word") {
    return {
      unit: null,
      number: null
    };
  }

  // Ignore non standard syntax
  if (!(0, _isStandardSyntaxValue["default"])(node.value)) {
    return {
      unit: null,
      number: null
    };
  }

  // Ignore HEX
  if (node.value.startsWith("#")) {
    return {
      unit: null,
      number: null
    };
  }

  // Remove non standard stuff
  var value = (0, _blurInterpolation["default"])(node.value, "")
  // ignore hack unit
  .replace("\\0", "").replace("\\9", "");
  var parsedUnit = _postcssValueParser["default"].unit(value);
  if (!parsedUnit) {
    return {
      unit: null,
      number: null
    };
  }
  return parsedUnit;
}