"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = hasEmptyBlock;
var _hasBlock = _interopRequireDefault(require("./hasBlock.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
/**
 * Check if a statement has an empty block.
 *
 * @param {import('postcss').Rule | import('postcss').AtRule} statement - postcss rule or at-rule node
 * @return {boolean} True if the statement has a block and it is empty
 */
function hasEmptyBlock(statement) {
  return (0, _hasBlock["default"])(statement) && statement.nodes.length === 0;
}