"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = hasInterpolation;
var _hasLessInterpolation = _interopRequireDefault(require("./hasLessInterpolation.js"));
var _hasPsvInterpolation = _interopRequireDefault(require("./hasPsvInterpolation.js"));
var _hasScssInterpolation = _interopRequireDefault(require("./hasScssInterpolation.js"));
var _hasTplInterpolation = _interopRequireDefault(require("./hasTplInterpolation.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
/**
 * Check whether a string has interpolation
 *
 * @param {string} string
 * @return {boolean} If `true`, a string has interpolation
 */
function hasInterpolation(string) {
  // SCSS or Less interpolation
  if ((0, _hasLessInterpolation["default"])(string) || (0, _hasScssInterpolation["default"])(string) || (0, _hasTplInterpolation["default"])(string) || (0, _hasPsvInterpolation["default"])(string)) {
    return true;
  }
  return false;
}