"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = isRangeContextMediaFeature;
/**
 * Check whether a media feature is a range context one
 *
 * @param {string} mediaFeature feature
 * @return {boolean} If `true`, media feature is a range context one
 */
function isRangeContextMediaFeature(mediaFeature) {
  return mediaFeature.includes("=") || mediaFeature.includes("<") || mediaFeature.includes(">");
}