"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = isStandardSyntaxMediaFeatureName;
/**
 * Check whether a media feature name is standard
 *
 * @param {string} mediaFeatureName
 * @returns {boolean}
 */
function isStandardSyntaxMediaFeatureName(mediaFeatureName) {
  // SCSS interpolation
  if (/#\{.+?\}|\$.+/.test(mediaFeatureName)) {
    return false;
  }
  return true;
}