"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = isStandardSyntaxProperty;
var _hasInterpolation = _interopRequireDefault(require("./hasInterpolation.js"));
var _isScssVariable = _interopRequireDefault(require("./isScssVariable.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
/**
 * Check whether a property is standard
 *
 * @param {string} property
 * @returns {boolean}
 */
function isStandardSyntaxProperty(property) {
  // SCSS var
  if ((0, _isScssVariable["default"])(property)) {
    return false;
  }

  // Less var (e.g. @var: x)
  if (property.startsWith("@")) {
    return false;
  }

  // Less append property value with space (e.g. transform+_: scale(2))
  if (property.endsWith("+") || property.endsWith("+_")) {
    return false;
  }

  // SCSS or Less interpolation
  if ((0, _hasInterpolation["default"])(property)) {
    return false;
  }
  return true;
}