"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = isStandardSyntaxRule;
var _isStandardSyntaxSelector = _interopRequireDefault(require("./isStandardSyntaxSelector.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
/**
 * Check whether a Node is a standard rule
 *
 * @param {import('postcss').Rule | import('postcss-less').Rule} rule
 * @returns {boolean}
 */
function isStandardSyntaxRule(rule) {
  if (rule.type !== "rule") {
    return false;
  }

  // Ignore Less &:extend rule
  if ("extend" in rule && rule.extend) {
    return false;
  }
  if (!(0, _isStandardSyntaxSelector["default"])(rule.selector)) {
    return false;
  }
  return true;
}