"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = matchesStringOrRegExp;
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
/**
 * Compares a string to a second value that, if it fits a certain convention,
 * is converted to a regular expression before the comparison.
 * If it doesn't fit the convention, then two strings are compared.
 *
 * Any strings starting and ending with `/` are interpreted
 * as regular expressions.
 *
 * @param {string | Array<string>} input
 * @param {string | RegExp | Array<string | RegExp>} comparison
 *
 * @returns {false | {match: string, pattern: (string | RegExp), substring: string}}
 */
function matchesStringOrRegExp(input, comparison) {
  if (!Array.isArray(input)) {
    return testAgainstStringOrRegExpOrArray(input, comparison);
  }
  var _iterator = _createForOfIteratorHelper(input),
    _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var inputItem = _step.value;
      var testResult = testAgainstStringOrRegExpOrArray(inputItem, comparison);
      if (testResult) {
        return testResult;
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  return false;
}

/**
 * @param {string} value
 * @param {string | RegExp | Array<string | RegExp>} comparison
 */
function testAgainstStringOrRegExpOrArray(value, comparison) {
  if (!Array.isArray(comparison)) {
    return testAgainstStringOrRegExp(value, comparison);
  }
  var _iterator2 = _createForOfIteratorHelper(comparison),
    _step2;
  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
      var comparisonItem = _step2.value;
      var testResult = testAgainstStringOrRegExp(value, comparisonItem);
      if (testResult) {
        return testResult;
      }
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }
  return false;
}

/**
 * @param {string} value
 * @param {string | RegExp} comparison
 */
function testAgainstStringOrRegExp(value, comparison) {
  // If it's a RegExp, test directly
  if (comparison instanceof RegExp) {
    var match = value.match(comparison);
    return match ? {
      match: value,
      pattern: comparison,
      substring: match[0] || ""
    } : false;
  }

  // Check if it's RegExp in a string
  var firstComparisonChar = comparison[0];
  var lastComparisonChar = comparison[comparison.length - 1];
  var secondToLastComparisonChar = comparison[comparison.length - 2];
  var comparisonIsRegex = firstComparisonChar === "/" && (lastComparisonChar === "/" || secondToLastComparisonChar === "/" && lastComparisonChar === "i");
  var hasCaseInsensitiveFlag = comparisonIsRegex && lastComparisonChar === "i";

  // If so, create a new RegExp from it
  if (comparisonIsRegex) {
    var valueMatch = hasCaseInsensitiveFlag ? value.match(new RegExp(comparison.slice(1, -2), "i")) : value.match(new RegExp(comparison.slice(1, -1)));
    return valueMatch ? {
      match: value,
      pattern: comparison,
      substring: valueMatch[0] || ""
    } : false;
  }

  // Otherwise, it's a string. Do a strict comparison
  return value === comparison ? {
    match: value,
    pattern: comparison,
    substring: value
  } : false;
}