"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = nextNonCommentNode;
/** @typedef {import('postcss').Node} PostcssNode */

/**
 * Get the next non-comment node in a PostCSS AST
 * at or after a given node.
 *
 * @param {PostcssNode | void} startNode
 * @returns {PostcssNode | null}
 */
function nextNonCommentNode(startNode) {
  if (!startNode || !startNode.next) {
    return null;
  }
  if (startNode.type === "comment") {
    return nextNonCommentNode(startNode.next());
  }
  return startNode;
}