"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = optionsMatches;
var _matchesStringOrRegExp = _interopRequireDefault(require("./matchesStringOrRegExp.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
/**
 * Check if an options object's propertyName contains a user-defined string or
 * regex that matches the passed in input.
 *
 * @param {{ [x: string]: any; }} options
 * @param {string} propertyName
 * @param {unknown} input
 *
 * @returns {boolean}
 */
function optionsMatches(options, propertyName, input) {
  return Boolean(options && options[propertyName] && _typeof(input) === "string" && (0, _matchesStringOrRegExp["default"])(input, options[propertyName]));
}