"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = parseSelector;
var _postcssSelectorParser = _interopRequireDefault(require("postcss-selector-parser"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
/**
 * @param {string} selector
 * @param {import('stylelint').PostcssResult} result
 * @param {import('postcss').Node} node
 * @param {(root: import('postcss-selector-parser').Root) => void} callback
 * @returns {string | undefined}
 */
function parseSelector(selector, result, node, callback) {
  try {
    return (0, _postcssSelectorParser["default"])(callback).processSync(selector);
  } catch (err) {
    result.warn("Cannot parse selector (".concat(err, ")"), {
      node: node,
      stylelintType: "parseError"
    });
    return undefined;
  }
}