"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = rawNodeString;
/**
 * Stringify PostCSS node including its raw "before" string.
 *
 * @param {import('postcss').Node} node
 *
 * @returns {string}
 */
function rawNodeString(node) {
  var result = "";
  if (node.raws.before) {
    result += node.raws.before;
  }
  result += node.toString();
  return result;
}