"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = report;
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
/**
 * Report a problem.
 *
 * This function accounts for `disabledRanges` attached to the result.
 * That is, if the reported problem is within a disabledRange,
 * it is ignored. Otherwise, it is attached to the result as a
 * postcss warning.
 *
 * It also accounts for the rule's severity.
 *
 * You *must* pass *either* a node or a line number.
 *
 * @type {import('stylelint').Utils['report']}
 */
function report(problem) {
  var ruleName = problem.ruleName,
    result = problem.result,
    message = problem.message,
    messageArgs = problem.messageArgs,
    line = problem.line,
    node = problem.node,
    index = problem.index,
    endIndex = problem.endIndex,
    word = problem.word,
    severity = problem.severity;
  result.stylelint = result.stylelint || {
    ruleSeverities: {},
    customMessages: {},
    ruleMetadata: {}
  };
  var ruleSeverity = severity || result.stylelint.ruleSeverities && result.stylelint.ruleSeverities[ruleName];

  // In quiet mode, mere warnings are ignored
  if (result.stylelint.quiet && ruleSeverity !== "error") {
    return;
  }
  var _ref = node && node.rangeBy({
      index: index,
      endIndex: endIndex
    }) || {},
    start = _ref.start;

  // If a line is not passed, use the node.rangeBy method to get the
  // line number that the complaint pertains to
  var startLine = line || start && start.line;
  if (!startLine) {
    throw new Error("You must pass either a node or a line number");
  }
  var _ref2 = result.stylelint.config || {},
    ignoreDisables = _ref2.ignoreDisables;
  if (result.stylelint.disabledRanges) {
    var ranges = result.stylelint.disabledRanges[ruleName] || result.stylelint.disabledRanges.all || [];
    var _iterator = _createForOfIteratorHelper(ranges),
      _step;
    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var range = _step.value;
        if (
        // If the problem is within a disabledRange,
        // and that disabledRange's rules include this one,
        // do not register a warning
        range.start <= startLine && (range.end === undefined || range.end >= startLine) && (!range.rules || range.rules.includes(ruleName))) {
          // Collect disabled warnings
          // Used to report `needlessDisables` in subsequent processing.
          var disabledWarnings = result.stylelint.disabledWarnings || (result.stylelint.disabledWarnings = []);
          disabledWarnings.push({
            rule: ruleName,
            line: startLine
          });
          if (!ignoreDisables) {
            return;
          }
          break;
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
  }
  if (!result.stylelint.stylelintError && ruleSeverity === "error") {
    result.stylelint.stylelintError = true;
  }
  if (!result.stylelint.stylelintWarning && ruleSeverity === "warning") {
    result.stylelint.stylelintWarning = true;
  }

  /** @type {import('stylelint').WarningOptions} */
  var warningProperties = {
    severity: ruleSeverity,
    rule: ruleName
  };
  if (node) {
    warningProperties.node = node;
  }
  if (problem.start) {
    warningProperties.start = problem.start;
  } else if (index) {
    warningProperties.index = index;
  }
  if (problem.end) {
    warningProperties.end = problem.end;
  } else if (endIndex) {
    warningProperties.endIndex = endIndex;
  }
  if (word) {
    warningProperties.word = word;
  }
  var customMessages = result.stylelint.customMessages;
  var warningMessage = buildWarningMessage(customMessages && customMessages[ruleName] || message, messageArgs);
  result.warn(warningMessage, warningProperties);
}

/**
 * @param {import('stylelint').RuleMessage} message
 * @param {import('stylelint').Problem['messageArgs']} messageArgs
 * @returns {string}
 */
function buildWarningMessage(message, messageArgs) {
  var args = messageArgs || [];
  if (_typeof(message) === "string") {
    return printfLike.apply(void 0, [message].concat(_toConsumableArray(args)));
  }
  return message.apply(void 0, _toConsumableArray(args));
}

/**
 * @param {string} format
 * @param {Array<unknown>} args
 * @returns {string}
 */
function printfLike(format) {
  for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }
  return args.reduce(function ( /** @type {string} */result, arg) {
    return result.replace(/%[ds]/, String(arg));
  }, format);
}