"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = setDeclarationValue;
/** @typedef {import('postcss').Declaration} Declaration */

/**
 * @param {Declaration} decl
 * @param {string} value
 * @returns {Declaration} The declaration that was passed in.
 */
function setDeclarationValue(decl, value) {
  var raws = decl.raws;
  if (raws.value) {
    raws.value.raw = value;
  } else {
    decl.value = value;
  }
  return decl;
}