"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = transformSelector;
var _postcssSelectorParser = _interopRequireDefault(require("postcss-selector-parser"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
/**
 * @param {import('stylelint').PostcssResult} result
 * @param {import('postcss').Rule} node
 * @param {(root: import('postcss-selector-parser').Root) => void} callback
 * @returns {string | undefined}
 */
function transformSelector(result, node, callback) {
  try {
    return (0, _postcssSelectorParser["default"])(callback).processSync(node, {
      updateSelector: true
    });
  } catch (_unused) {
    result.warn("Cannot parse selector", {
      node: node,
      stylelintType: "parseError"
    });
    return undefined;
  }
}