"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = validateOptions;
var _arrayEqual = _interopRequireDefault(require("./arrayEqual.js"));
var _validateTypes = require("./validateTypes.js");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var IGNORED_OPTIONS = new Set(["severity", "message", "reportDisables", "disableFix"]);

/** @typedef {import('stylelint').RuleOptions} RuleOptions */
/** @typedef {import('stylelint').RuleOptionsPossible} RuleOptionsPossible */

/**
 * @type {import('stylelint').Utils['validateOptions']}
 */
function validateOptions(result, ruleName) {
  var noErrors = true;
  for (var _len = arguments.length, optionDescriptions = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
    optionDescriptions[_key - 2] = arguments[_key];
  }
  for (var _i = 0, _optionDescriptions = optionDescriptions; _i < _optionDescriptions.length; _i++) {
    var optionDescription = _optionDescriptions[_i];
    validate(optionDescription, ruleName, complain);
  }

  /**
   * @param {string} message
   */
  function complain(message) {
    noErrors = false;
    result.warn(message, {
      stylelintType: "invalidOption"
    });
    result.stylelint = result.stylelint || {
      disabledRanges: {},
      ruleSeverities: {},
      customMessages: {},
      ruleMetadata: {}
    };
    result.stylelint.stylelintError = true;
  }
  return noErrors;
}

/**
 * @param {RuleOptions} opts
 * @param {string} ruleName
 * @param {(message: string) => void} complain
 */
function validate(opts, ruleName, complain) {
  var possible = opts.possible;
  var actual = opts.actual;
  var optional = opts.optional;
  if (actual === false && !ruleName.startsWith("report")) {
    return complain("Invalid option value \"false\" for rule \"".concat(ruleName, "\". Are you trying to disable this rule? If so use \"null\" instead"));
  }
  if (actual === null || (0, _arrayEqual["default"])(actual, [null])) {
    return;
  }
  var nothingPossible = possible === undefined || Array.isArray(possible) && possible.length === 0;
  if (nothingPossible && actual === true) {
    return;
  }
  if (actual === undefined) {
    if (nothingPossible || optional) {
      return;
    }
    complain("Expected option value for rule \"".concat(ruleName, "\""));
    return;
  }
  if (nothingPossible) {
    if (optional) {
      complain("Incorrect configuration for rule \"".concat(ruleName, "\". Rule should have \"possible\" values for options validation"));
      return;
    }
    complain("Unexpected option value ".concat(stringify(actual), " for rule \"").concat(ruleName, "\""));
    return;
  }
  if (_typeof(possible) === "function") {
    if (!possible(actual)) {
      complain("Invalid option ".concat(stringify(actual), " for rule \"").concat(ruleName, "\""));
    }
    return;
  }

  // If `possible` is an array instead of an object ...
  if (Array.isArray(possible)) {
    var _iterator = _createForOfIteratorHelper([actual].flat()),
      _step;
    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var a = _step.value;
        if (isValid(possible, a)) {
          continue;
        }
        complain("Invalid option value ".concat(stringify(a), " for rule \"").concat(ruleName, "\""));
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
    return;
  }

  // If actual is NOT an object ...
  if (!(0, _validateTypes.isPlainObject)(actual) || _typeof(actual) !== "object" || actual === null) {
    complain("Invalid option value ".concat(stringify(actual), " for rule \"").concat(ruleName, "\": should be an object"));
    return;
  }
  for (var _i2 = 0, _Object$entries = Object.entries(actual); _i2 < _Object$entries.length; _i2++) {
    var _Object$entries$_i = _slicedToArray(_Object$entries[_i2], 2),
      optionName = _Object$entries$_i[0],
      optionValue = _Object$entries$_i[1];
    if (IGNORED_OPTIONS.has(optionName)) {
      continue;
    }
    var possibleValue = possible && possible[optionName];
    if (!possibleValue) {
      complain("Invalid option name \"".concat(optionName, "\" for rule \"").concat(ruleName, "\""));
      continue;
    }
    var _iterator2 = _createForOfIteratorHelper([optionValue].flat()),
      _step2;
    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var _a = _step2.value;
        if (isValid(possibleValue, _a)) {
          continue;
        }
        complain("Invalid value ".concat(stringify(_a), " for option \"").concat(optionName, "\" of rule \"").concat(ruleName, "\""));
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }
  }
}

/**
 * @param {RuleOptionsPossible | RuleOptionsPossible[]} possible
 * @param {unknown} actual
 * @returns {boolean}
 */
function isValid(possible, actual) {
  var _iterator3 = _createForOfIteratorHelper([possible].flat()),
    _step3;
  try {
    for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
      var possibility = _step3.value;
      if (_typeof(possibility) === "function" && possibility(actual)) {
        return true;
      }
      if (actual === possibility) {
        return true;
      }
    }
  } catch (err) {
    _iterator3.e(err);
  } finally {
    _iterator3.f();
  }
  return false;
}

/**
 * @param {unknown} value
 * @returns {string}
 */
function stringify(value) {
  if (_typeof(value) === "string") {
    return "\"".concat(value, "\"");
  }
  return "\"".concat(JSON.stringify(value), "\"");
}