'use client'

import { Button } from "@/components/ui";
import { cn } from "@/lib/utils";
import Image from "next/image";

/**
 * DashboardCards Component
 * Ana sayfa dashboard kartları
 * Şarkı dinle kazan, liderlik sıralaması, görevler ve referanslar bölümleri
 */
const DashboardCards = () => {
  return (
    <div className="w-full flex flex-col lg:flex-row gap-4 pt-20 p-4 h-fit">
      <div className="w-full lg:w-[70%] h-fit flex flex-col gap-4">
        <div className="flex flex-col sm:flex-row gap-4 h-fit">

        <div className="w-full sm:w-[60%]   
          flex justify-start items-center
          relative bg-gradient-to-r overflow-hidden rounded-2xl lg:rounded-3xl from-[#71469B] via-[#6F4599] to-[#311B48] min-h-[180px] sm:h-46">
              <Image
              src="/assets/images/dinle_kazan.png"
              alt="Description of image"
              width={100}
              height={100}
              objectFit="contain"
              unoptimized
              quality={100}
              className={cn('w-[200px] sm:w-[360px] absolute -right-10 sm:-right-20 -bottom-5 sm:-bottom-10 h-auto',
              
              )}
              />

              <div className="flex flex-col w-[60%] sm:w-[60%] px-3 sm:px-4 items-start gap-4 sm:gap-8">
                <div className="flex flex-col items-start gap-1">
                <h2 className="text-base sm:text-xl font-semibold">Şarkı Dinle Kazan</h2>
                <p className="text-white/70 text-xs sm:text-sm">Spotify&apos;da her dinleme sadece müzik değil, sana kazanç da getirir</p>
                

                </div>
               <Button variant="outline" size="sm">
                  Hemen Başla
                </Button>
              </div>

       </div>

      <div className="w-full sm:w-[40%] pb-5 relative overflow-hidden rounded-2xl lg:rounded-3xl bg-gradient-to-r from-[#3355AB] to-[#1A294F] min-h-[180px] sm:h-46 flex justify-start items-center">

              <Image
              src="/assets/images/liderlik_sıralaması.png"
              alt="Description of image"
              width={100}
              height={100}
              objectFit="contain"
              unoptimized
              quality={100}
              className={cn('w-[150px] sm:w-[240px] absolute -right-10 sm:-right-20 -bottom-5 sm:-bottom-10 h-auto',
              
              )}
              />

              <div className="flex flex-col w-[70%] px-3 sm:px-4 items-start gap-4 sm:gap-8">
                <div className="flex flex-col items-start gap-1">
                <h2 className="text-base sm:text-xl font-semibold">Referans Liderlik
Sıralaması</h2>
                <p className="text-white/70 text-xs sm:text-sm">Spotify&apos;da her dinleme sadece müzik değil, sana kazanç da getirir</p>
                

                </div>
              </div>


      </div>
        </div>
      
     <div className="flex flex-col sm:flex-row gap-4 h-fit w-full">
      <div className="w-full sm:w-[30%] pb-10 relative overflow-hidden flex items-center rounded-2xl lg:rounded-3xl min-h-[180px] sm:h-46 bg-gradient-to-r from-[#B73838] to-[#4A2626]">
      <Image
              src="/assets/images/görevler.png"
              alt="Description of image"
              width={100}
              height={100}
              objectFit="contain"
              unoptimized
              quality={100}
              className={cn('w-[200px] sm:w-[380px] absolute -right-10 sm:-right-25 -bottom-5 sm:-bottom-15 h-auto',
              
              )}
              />

              <div className="flex flex-col px-3 sm:px-4 items-start gap-4 sm:gap-8">
                <div className="flex flex-col items-start gap-1">
                <h2 className="text-base sm:text-xl w-full font-semibold">Yeni Görevler</h2>
                <p className="text-white/70 text-xs sm:text-sm">Her gün eklenen yeni görevlerle daha fazla kazanma fırsatını yakala</p>
                

                </div>
              
              </div>

      </div>
      <div className="w-full sm:w-[70%] relative overflow-hidden flex items-center rounded-2xl lg:rounded-3xl min-h-[180px] sm:h-46 bg-gradient-to-r from-[#5B3725] to-[#3C242B]"> 

          <Image
              src="/assets/images/dinle_kazan.png"
              alt="Description of image"
              width={100}
              height={100}
              objectFit="contain"
              unoptimized
              quality={100}
              className={cn('w-[200px] sm:w-[360px] absolute -right-10 sm:-right-20 -bottom-5 sm:-bottom-10 h-auto',
              
              )}
              />

              <div className="flex flex-col w-[60%] px-3 sm:px-4 items-start gap-4 sm:gap-8">
                <div className="flex flex-col items-start gap-1">
                <h2 className="text-base sm:text-xl font-semibold">Liderlik Sıralaması</h2>
                <p className="text-white/70 text-xs sm:text-sm">Kazançlarıyla öne çıkan, ödülleriyle liderliği kapanlar burada</p>
                

                </div>
               <Button variant="outline" size="sm">
                  Hemen Başla
                </Button>
              </div>

      </div>
    
     </div>
      </div>
      <div className="w-full lg:w-[30%] h-[300px] sm:h-[385px] relative overflow-hidden flex items-start pt-5 rounded-2xl lg:rounded-3xl bg-gradient-to-r from-[#53637D] to-[#222833]">
          <Image
              src="/assets/images/referanslar.png"
              alt="Description of image"
              width={100}
              height={100}
              objectFit="contain"
              unoptimized
              quality={100}
              className={cn('w-[200px] sm:w-[300px] absolute -right-2 sm:-right-5 bottom-0 h-auto',
              
              )}
              />

              <div className="flex flex-col w-[70%] px-3 sm:px-4 items-start gap-4 sm:gap-8">
                <div className="flex flex-col items-start gap-1">
                <h2 className="text-base sm:text-xl font-semibold">Referans İle Daha
Çok Kazan</h2>
                <p className="text-white/70 text-xs sm:text-sm">Kazancınızı artırmanın en hızlı yolunu keşfedin.</p>
                

                </div>
               <Button variant="outline" size="sm">
                 Referanslar
                </Button>
              </div>
      </div>
    
     </div>
  );
};

export { DashboardCards };
export default DashboardCards;