import Image from 'next/image'

export function MobileDashboardCards() {
  const cards = [
    { id: 1, image: '/assets/images/mobile_home_card/1.png' },
    { id: 2, image: '/assets/images/mobile_home_card/2.png' },
    { id: 3, image: '/assets/images/mobile_home_card/3.png' },
    { id: 4, image: '/assets/images/mobile_home_card/4.png' },
    { id: 5, image: '/assets/images/mobile_home_card/5.png' }
  ]

  return (
    <div className="w-full pt-0 px-3 py-3">
      <div className="space-y-2 w-full">
        {/* 1. Satır - 1. ve 2. resim yan yana (362x226 oranı) */}
        <div className="grid grid-cols-2 gap-2 w-full">
          {cards.slice(0, 2).map((card) => (
            <div
              key={card.id}
              className="relative w-full aspect-[362/226] rounded-xl overflow-hidden hover:scale-[1.02] transition-transform duration-300"
            >
              <Image
                src={card.image}
                alt={`Dashboard Card ${card.id}`}
                fill
                className="object-cover"
                quality={100}
                unoptimized
              />
            </div>
          ))}
        </div>

        {/* 2. Satır - 3., 4. ve 5. resim yan yana (286x231 oranı) */}
        <div className="grid grid-cols-3 gap-2 w-full">
          {cards.slice(2, 5).map((card) => (
            <div
              key={card.id}
              className="relative w-full aspect-[286/231] rounded-xl overflow-hidden hover:scale-[1.02] transition-transform duration-300"
            >
              <Image
                src={card.image}
                alt={`Dashboard Card ${card.id}`}
                fill
                className="object-cover"
                quality={100}
                unoptimized
              />
            </div>
          ))}
        </div>
      </div>
    </div>
  )
}
