'use client'

import { useEffect, useState } from 'react'
import PageLoader from '@/components/ui/PageLoader'

export default function Loading() {
  const [mounted, setMounted] = useState(true)
  const [isClosing, setIsClosing] = useState(false)

  useEffect(() => {
    // 1.8 saniye sonra kapanma animasyonunu başlat
    const hideTimer = setTimeout(() => {
      setIsClosing(true)
    }, 1800)

    // Kapanma animasyonu bittikten sonra unmount et (700ms animasyon + buffer)
    const unmountTimer = setTimeout(() => {
      setMounted(false)
    }, 2600)

    return () => {
      clearTimeout(hideTimer)
      clearTimeout(unmountTimer)
    }
  }, [])

  if (!mounted) return null
  
  return <PageLoader isClosing={isClosing} />
}
