'use client'

import { useState, useMemo } from "react";
import { PlatformSelector } from "@/components/ui";
import { StatCard, TaskTable } from "../_components";
import Image from "next/image";
import { ongoingTasks, completedTasks, withdrawalTasks } from '@/data';
import { isArray } from '@/lib/guards';

export default function ProfilePage() {
  const [activeTab, setActiveTab] = useState<string>('ongoing');

  // Validate data from imports
  const validatedOngoingTasks = useMemo(() => {
    return isArray(ongoingTasks) ? ongoingTasks : [];
  }, []);

  const validatedCompletedTasks = useMemo(() => {
    return isArray(completedTasks) ? completedTasks : [];
  }, []);

  const validatedWithdrawalTasks = useMemo(() => {
    return isArray(withdrawalTasks) ? withdrawalTasks : [];
  }, []);

  // Kullanıcı bilgileri
  const userInfo = {
    name: "Arda Kılıç",
    username: "@ardakilic",
    avatar: "/assets/images/pp1.png",
    joinedDaysAgo: 65,
    stats: {
      totalEarnings: "21.050₺",
      completedOffers: 23,
      referrals: 243,
      last28DaysEarnings: "129.944₺"
    }
  };

  // Görev verileri - Devam Eden Kazançlar

  // Tamamlanan Görevler

  // Çekim İşlemlerim

  const getCurrentTasks = () => {
    switch (activeTab) {
      case 'ongoing':
        return validatedOngoingTasks;
      case 'completed':
        return validatedCompletedTasks;
      case 'withdrawals':
        return validatedWithdrawalTasks;
      default:
        return validatedOngoingTasks;
    }
  };

  const tabOptions = [
    { id: 'ongoing', label: 'Devam Eden Kazançlar', value: 'ongoing' },
    { id: 'completed', label: 'Tamamlanan Görevler', value: 'completed' },
    { id: 'withdrawals', label: 'Çekim İşlemlerim', value: 'withdrawals' }
  ];

  return (

    <div className="md:h-screen pt-20  overflow-y-auto w-full px-2 py-4 md:p-6 md:pt-20">
      {/* Üst Profil Alanı */}
      <div className="w-full mb-6">
        <div className="grid md:grid-cols-2 gap-4 md:gap-6">
          {/* Sol Taraf - Kullanıcı Bilgileri */}
          <div className="flex flex-col sm:flex-row rounded-3xl p-4 md:p-8 w-full items-center bg-base-2 gap-3 md:gap-10">
            <div className="relative mb-3 sm:mb-0">
              <Image
                src={userInfo.avatar}
                alt={userInfo.name}
                width={80}
                height={80}
                className="rounded-full"
              />
              <div className="absolute w-26 h-26 md:w-30 md:h-30 left-1/2 transform -translate-x-1/2  top-1/2 -translate-y-1/2">
              <svg  viewBox="0 0 184 184" fill="none" xmlns="http://www.w3.org/2000/svg">
              <circle cx="92.3318" cy="91.3899" r="76.3152" fill="white" fill-opacity="0.05"/>
              <circle cx="91.8608" cy="91.8608" r="91.8608" fill="white" fill-opacity="0.05"/>
              </svg>


              </div>

              <span className="absolute -right-1 bottom-1 w-5 h-5 bg-green-400 border-4 border-base-2 rounded-full" />
            </div>
            <div className="text-center sm:text-left">
              <h1 className="text-lg md:text-xl font-semibold text-white">{userInfo.name}</h1>
              <p className="text-gray-400 text-sm md:text-base">{userInfo.username}</p>
              <p className="text-xs md:text-sm text-gray-500 mt-1">
                {userInfo.joinedDaysAgo} Gün Önce Katıldı
              </p>
            </div>
          </div>

          {/* Sağ Taraf - İstatistikler Grid */}
          <div className={`grid ${activeTab === 'withdrawals' ? 'grid-cols-2 lg:grid-cols-3' : 'grid-cols-2'} gap-2 md:gap-4 rounded-3xl px-2 py-4 md:px-8 md:py-4 bg-base-2 w-full`}>
            <StatCard
              icon="tdesign:money-filled"
              value={userInfo.stats.totalEarnings}
              label="Toplam Kazanç"
            />
             {activeTab === 'withdrawals' && (
              <StatCard
                icon="ph:hand-withdraw-bold"
                value="12.500₺"
                label="Çekilen Toplam Tutar"
              />
            )}
            <StatCard
              icon="material-symbols:domain-verification-rounded"
              value={userInfo.stats.completedOffers}
              label="Tamamlanan Teklifler"
            />
            <StatCard
              icon="clarity:users-solid"
              value={userInfo.stats.referrals}
              label="Referanslarım"
            />
            <StatCard
              icon="material-symbols:history-rounded"
              value={userInfo.stats.last28DaysEarnings}
              label="Son 28 Günün Kazançları"
            />
           
          </div>
        </div>
      </div>

      {/* Sekme Menüsü */}
      <div className="md:block hidden mb-6 md:w-3xl">
        <PlatformSelector
          options={tabOptions}
          defaultSelected={activeTab}
          onChange={setActiveTab}
          size="md"
          className="w-full max-w-3xl"
        />
      </div>
      {/* Sekme Menüsü */}
      <div className="md:hidden mb-6 md:w-3xl">
        <PlatformSelector
          options={tabOptions}
          defaultSelected={activeTab}
          onChange={setActiveTab}
          size="sm"
          className="w-full max-w-3xl"
        />
      </div>

      {/* Görev Tablosu */}
      <TaskTable 
        tasks={getCurrentTasks()} 
        headers={
          activeTab === 'withdrawals' 
            ? {
                taskName: 'Çekim Ağı',
                description: 'İşlem Numarası',
                date: 'İşlem Tarihi',
                amount: 'Tutar',
                status: 'Durum'
              }
            : undefined
        }
      />
      {/* Görev Tablosu */}
    </div>
  );
}
