'use client'

import { useState, useMemo } from "react";
import { Iconify, PlatformSelector } from "@/components/ui";
import { Footer } from "@/components/layout";
import { StatCard, TaskTable, LeaderboardSection, RewardsSection, type Task } from "../_components";
import Image from "next/image";
import { isArray } from '@/lib/guards';

export default function ProfilePage() {
  const [activeTab, setActiveTab] = useState<string>('referrals');

  // Kullanıcı bilgileri
  const userInfo = {
    name: "Arda Kılıç",
    username: "@ardakilic",
    avatar: "/assets/images/pp1.png",
    joinedDaysAgo: 65,
    stats: {
      totalReferralEarnings: "10.256₺",
      last7DaysEarnings: "5.680₺",
      totalReferralCount: "324",
      todayEarnings: "2.550₺",
      last28DaysEarnings: "8.340₺",
      totalClicks: "21.050"
    }
  };

  // Referans Listesi
  const referralsList: Task[] = [
    {
      id: "ref-1",
      logo: "/assets/images/pp1.png",
      title: "Sophia Reed",
      description: "",
      amount: "435.23₺",
      status: "6",
      date: "42.50₺"
    },
    {
      id: "ref-2",
      logo: "/assets/images/pp1.png",
      title: "Sophia Reed",
      description: "",
      amount: "435.23₺",
      status: "6",
      date: "42.50₺"
    },
    {
      id: "ref-3",
      logo: "/assets/images/pp1.png",
      title: "Sophia Reed",
      description: "",
      amount: "435.23₺",
      status: "6",
      date: "42.50₺"
    },
    {
      id: "ref-4",
      logo: "/assets/images/pp1.png",
      title: "Sophia Reed",
      description: "",
      amount: "435.23₺",
      status: "6",
      date: "42.50₺"
    }
  ];

  // Referans Link Kazançları
  const referralLinkEarnings: Task[] = [
    {
      id: "link-1",
      logo: "/assets/images/denizbank.png",
      title: "Deniz Bank Referans Kazancı",
      description: "Instagram kampanyası üzerinden kazanç",
      amount: "125.50₺",
      status: "Tamamlandı",
      date: "15.10.2025"
    },
    {
      id: "link-2",
      logo: "/assets/images/denizbank.png",
      title: "Garanti BBVA Referans",
      description: "TikTok kampanyası referans kazancı",
      amount: "89.30₺",
      status: "Tamamlandı",
      date: "14.10.2025"
    },
    {
      id: "link-3",
      logo: "/assets/images/denizbank.png",
      title: "İş Bankası Referans",
      description: "Twitter kampanyası kazancı",
      amount: "156.75₺",
      status: "Tamamlandı",
      date: "13.10.2025"
    },
    {
      id: "link-4",
      logo: "/assets/images/denizbank.png",
      title: "Yapı Kredi Referans",
      description: "YouTube kampanyası referans",
      amount: "92.40₺",
      status: "Tamamlandı",
      date: "12.10.2025"
    }
  ];

  // Leaderboard Verileri
  const leaderboardUsers = [
    { rank: 1, name: "Bryan Wolf", avatar: "/assets/images/pp1.png", amount: "110.000₺" },
    { rank: 2, name: "Meghan Jes...", avatar: "/assets/images/pp1.png", amount: "58.000₺" },
    { rank: 3, name: "Alex Turner", avatar: "/assets/images/pp1.png", amount: "20.000₺" },
    { rank: 4, name: "Marsha Fisher", avatar: "/assets/images/pp1.png", amount: "8.500₺" },
    { rank: 5, name: "Juanita Cormier", avatar: "/assets/images/pp1.png", amount: "8.500₺" },
    { rank: 6, name: "You", avatar: "/assets/images/pp1.png", amount: "8.500₺" },
    { rank: 7, name: "Tamara Schmidt", avatar: "/assets/images/pp1.png", amount: "8.500₺" },
    { rank: 8, name: "Ricardo Veum", avatar: "/assets/images/pp1.png", amount: "8.500₺" },
    { rank: 9, name: "Gary Sanford", avatar: "/assets/images/pp1.png", amount: "8.500₺" },
    { rank: 10, name: "Becky Bartell", avatar: "/assets/images/pp1.png", amount: "8.500₺" },
  ];

  // Ödül Verileri
  const rewards = [
    {
      id: 1,
      title: "1 Adet Apple iPhone 17",
      subtitle: "1.Olan kişinin alacağı ödül",
      image: "/assets/images/iphone.png", 
      rank: "1"
    },
    {
      id: 2,
      title: "1 Adet Playstation 5 (PS5)",
      subtitle: "2.Olan kişinin alacağı ödül",
      image: "/assets/images/ps5.png", // TODO: PS5 görselini ekle
      rank: "2"
    },
    {
      id: 3,
      title: "1 Adet Cumhuriyet Altını",
      subtitle: "3.Olan kişinin alacağı ödül",
      image: "/assets/images/gold.png", // TODO: Altın görselini ekle
      rank: "3"
    }
  ];


  const getCurrentTasks = () => {
    const tasks = activeTab === 'referrals' ? referralsList : referralLinkEarnings;
    return isArray(tasks) ? tasks : [];
  };

  // Validate arrays
  const validatedLeaderboardUsers = useMemo(() => {
    return isArray(leaderboardUsers) ? leaderboardUsers : [];
  }, [leaderboardUsers]);

  const validatedRewards = useMemo(() => {
    return isArray(rewards) ? rewards : [];
  }, [rewards]);

  const tabOptions = [
    { id: 'referrals', label: 'Referanslar', value: 'referrals' },
    { id: 'earnings', label: 'Referans Liderlik Kazançları', value: 'earnings' },
  ];

  return (
    <div className="md:h-screen pt-20 md:pt-0 overflow-y-auto  w-full p-3 md:p-6 lg:pt-20 lg:p-4">
      {/* Üst Profil Alanı */}
      <div className=" w-full space-y-3 md:space-y-4 mb-4 md:mb-6">
        <div className="flex flex-col rounded-2xl md:rounded-3xl bg-base-2 lg:flex-row items-start lg:items-center justify-between">
          
          {/* Sol Taraf - Kullanıcı Bilgileri */}
          <div className="flex p-4 md:p-12 h-auto md:h-50 w-full lg:w-1/3 items-center gap-3">
            <div className="relative">
              <Image
                src={userInfo.avatar}
                alt={userInfo.name}
                width={80}
                height={80}
                className="rounded-full w-16 h-16 md:w-20 md:h-20"
              />
              <span className="absolute -right-1 bottom-1 w-4 h-4 md:w-5 md:h-5 bg-green-400 border-2 md:border-4 border-base-2 rounded-full" />
            </div>
            <div>
              <h1 className="text-base md:text-xl font-semibold text-white">{userInfo.name}</h1>
              <p className="text-sm md:text-base text-gray-400">{userInfo.username}</p>
              <p className="text-xs md:text-sm text-gray-500 mt-1">
                {userInfo.joinedDaysAgo} Gün Önce Katıldı
              </p>
            </div>
          </div>

         {/* Sol Taraf - Kullanıcı Bilgileri */}
          {/* Sağ Taraf - İstatistikler Grid */}
          <div className="grid content-between items-center md:h-50 px-4 md:px-24 py-4 grid-cols-2 md:grid-cols-3 w-full lg:w-2/3 gap-2 md:gap-4">
            {/* Üst Sıra */}
            <StatCard
              icon="tdesign:money-filled"
              value={userInfo.stats.totalReferralEarnings}
              label="Toplam Referans Kazancı"
            />
            
            <StatCard
              icon="solar:graph-up-bold"
              value={userInfo.stats.last7DaysEarnings}
              label="Son 7 Gün Referans Kazancı"
            />
            
            <StatCard
              icon="solar:users-group-rounded-bold"
              value={userInfo.stats.totalReferralCount}
              label="Toplam Referans Sayısı"
            />
            
            {/* Alt Sıra */}
            <StatCard
              icon="solar:graph-up-bold"
              value={userInfo.stats.todayEarnings}
              label="Bugünkü Referans Kazancı"
            />

            <StatCard
              icon="solar:graph-up-bold"
              value={userInfo.stats.last28DaysEarnings}
              label="Son 28 Gün Referans Kazancı"
              
            />

            <StatCard
              icon="solar:cursor-bold"
              value={userInfo.stats.totalClicks}
              label="Toplam Tıklama Sayısı"
            />
          </div>
        </div>
        {/* Bu kısım */}
        <div className="flex flex-col rounded-2xl md:rounded-3xl bg-base-2 lg:flex-row items-start justify-between p-4 md:p-8 gap-4 md:gap-6">
          
          {/* Sol Taraf - Referans Linkiniz */}
          <div className="flex-1 space-y-3 md:space-y-4 w-full">
            <div className="flex items-start gap-2 md:gap-3">
              <div className="bg-base-3 w-12 h-12  relative flex items-center justify-center rounded-xl flex-shrink-0">
                <Iconify className="relative" icon="line-md:link" size={24} />
              </div>
              <div className="flex-1 min-w-0">
                <h2 className="text-base md:text-xl font-semibold text-white mb-1 md:mb-2">Referans Linkiniz</h2>
                <p className="text-xs md:text-sm text-gray-400 leading-relaxed">
                  Referans linkinizle kayıt ettirdiğiniz üyelerin her birinin yaptığı görevlerin kazancından ömür boyu %10 pay alırsınız. Kayıt ettirdiğiniz üyelerden bu kar düşülmez. Tamamen kazanç odaklı bir sistemdir. Referans kodunuzla istediğiniz kadar üye kayıt ettirebilirsiniz.
                </p>
              </div>
            </div>
            
            {/* Link Input */}
            <div className="bg-base-3 rounded-xl py-2 px-3 md:px-4 flex items-center justify-between gap-2">
              <span className="text-white font-mono text-xs md:text-sm truncate">https://kiqro.com/ref/ardakilic</span>
              <button className="p-1.5 md:p-2 hover:bg-base-2 rounded-lg transition flex-shrink-0">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" className="md:w-5 md:h-5">
                  <path d="M8 4V16C8 16.5304 8.21071 17.0391 8.58579 17.4142C8.96086 17.7893 9.46957 18 10 18H18M8 4C8 3.46957 8.21071 2.96086 8.58579 2.58579C8.96086 2.21071 9.46957 2 10 2H15.5858C15.851 2 16.1054 2.10536 16.2929 2.29289L19.7071 5.70711C19.8946 5.89464 20 6.149 20 6.41421V16C20 16.5304 19.7893 17.0391 19.4142 17.4142C19.0391 17.7893 18.5304 18 18 18M8 4C7.46957 4 6.96086 4.21071 6.58579 4.58579C6.21071 4.96086 6 5.46957 6 6V20C6 20.5304 6.21071 21.0391 6.58579 21.4142C6.96086 21.7893 7.46957 22 8 22H16C16.5304 22 17.0391 21.7893 17.4142 21.4142C17.7893 21.0391 18 20.5304 18 20V18" stroke="white" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"/>
                </svg>
              </button>
            </div>
          </div>

          {/* Sağ Taraf - Referans Kodunuz & Paylaş */}
          <div className="flex-1 w-full lg:w-1/2">
            <div className="mb-3 md:mb-4">
              <h2 className="text-base md:text-xl font-semibold text-white mb-1 md:mb-2">Referans Kodunuz & Paylaş</h2>
              <p className="text-xs md:text-sm text-gray-400 leading-relaxed">
                Referans linkinizi ya da aşağıdaki referans kodunuzu arkadaşlarınızla paylaşabilirsiniz.
              </p>
            </div>
            <div className="flex flex-col sm:flex-row items-start sm:items-center justify-start gap-3 md:gap-4">
            {/* Kod Input */}
            <div className="bg-base-3 rounded-xl py-2 px-3 md:px-4 flex items-center justify-between gap-2 w-full sm:w-auto">
              <span className="text-white font-mono text-base md:text-xl font-semibold">ardakilic</span>
              <button className="p-1.5 md:p-2 hover:bg-base-2 rounded-lg transition flex-shrink-0">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" className="md:w-5 md:h-5">
                  <path d="M8 4V16C8 16.5304 8.21071 17.0391 8.58579 17.4142C8.96086 17.7893 9.46957 18 10 18H18M8 4C8 3.46957 8.21071 2.96086 8.58579 2.58579C8.96086 2.21071 9.46957 2 10 2H15.5858C15.851 2 16.1054 2.10536 16.2929 2.29289L19.7071 5.70711C19.8946 5.89464 20 6.149 20 6.41421V16C20 16.5304 19.7893 17.0391 19.4142 17.4142C19.0391 17.7893 18.5304 18 18 18M8 4C7.46957 4 6.96086 4.21071 6.58579 4.58579C6.21071 4.96086 6 5.46957 6 6V20C6 20.5304 6.21071 21.0391 6.58579 21.4142C6.96086 21.7893 7.46957 22 8 22H16C16.5304 22 17.0391 21.7893 17.4142 21.4142C17.7893 21.0391 18 20.5304 18 20V18" stroke="white" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"/>
                </svg>
              </button>
            </div>

            {/* Sosyal Medya Paylaşım Butonları */}
            <div className="flex items-center gap-2 md:gap-3 flex-wrap">
              <button className="p-2 md:p-3 bg-base-3 hover:bg-base-3/80 rounded-xl transition">
                <Iconify icon="ic:baseline-whatsapp" size={20} className="md:w-6 md:h-6" color="white" />
              </button>

              <button className="p-2 md:p-3 bg-base-3 hover:bg-base-3/80 rounded-xl transition">
                <Iconify icon="mdi:instagram" size={20} className="md:w-6 md:h-6" color="white" />
              </button>

              <button className="p-2 md:p-3 bg-base-3 hover:bg-base-3/80 rounded-xl transition">
                <Iconify icon="prime:twitter" size={20} className="md:w-6 md:h-6" color="white" />
              </button>

              <button className="p-2 md:p-3 bg-base-3 hover:bg-base-3/80 rounded-xl transition">
                <Iconify icon="ic:outline-telegram" size={20} className="md:w-6 md:h-6" color="white" />
              </button>

              <button className="p-2 md:p-3 bg-base-3 hover:bg-base-3/80 rounded-xl transition">
                <Iconify icon="ri:facebook-fill" size={20} className="md:w-6 md:h-6" color="white" />
              </button>
            </div>
            </div>
          </div>

        </div>
        {/* Bu kısım */}
      </div>

      {/* Sekme Menüsü */}
      <div className="mb-4 md:mb-6 w-full ">
        <PlatformSelector
          options={tabOptions}
          defaultSelected={activeTab}
          onChange={setActiveTab}
          size="md"
          className="w-full "
        />
      </div>

      {/* İçerik - Sekmeye Göre */}
      {activeTab === 'referrals' ? (
        /* Referans Tablosu */
        <TaskTable 
          tasks={getCurrentTasks()}
          headers={{
            taskName: 'Referanslar',
            amount: 'Kazandığı Tutar',
            status: 'Tamamlanan Teklifler',
            date: 'Komisyonun'
          }}
        />
      ) : (
        /* Leaderboard ve Ödüller */
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-4 md:gap-6">
          <LeaderboardSection users={validatedLeaderboardUsers} currentUserRank={6} />
          <RewardsSection rewards={validatedRewards} />
        </div>
      )}
      
      <Footer />
    </div>
  );
}