import Image from "next/image";
import type { ChatMessage as ChatMessageType } from "@/data";

interface ChatMessageProps {
  message: ChatMessageType;
}

export default function ChatMessage({ message }: ChatMessageProps) {
  return (
    <div className={`flex items-start gap-3 ${message.isUser ? 'flex-row-reverse' : ''}`}>
      {/* Avatar */}
      <div className="relative flex-shrink-0">
        <Image
          src={message.avatar}
          alt={message.sender}
          width={40}
          height={40}
          className="w-10 h-10 rounded-full object-cover"
        />
      </div>

      {/* Message Content */}
      <div className={`flex-1 min-w-0 max-w-[70%] ${message.isUser ? 'flex flex-col items-end' : ''}`}>
        <div className="flex items-center gap-2 mb-1">
          <span className="text-white font-medium text-sm">
            {message.sender}
          </span>
        </div>
        <div className={`relative rounded-2xl p-3 ${
          message.isUser 
            ? 'bg-primary rounded-br-none' 
            : 'bg-base-3 rounded-bl-none'
        }`}>
          {!message.isUser && (
            <span className='absolute -left-2.5 -bottom-1'>
              <svg width="27" height="28" viewBox="0 0 27 28" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M7.09989 21.8499C11.6643 16.8499 10.65 0.849945 10.65 0.849945L26.8789 20.3499C20.7931 25.3499 11.6643 28.8499 -0.000267029 27.3499C-0.000267029 27.3499 2.5355 26.8499 7.09989 21.8499Z" fill="#211D2F"/>
              </svg>
            </span>
          )}
          {message.isUser && (
            <span className='absolute -right-2.5 -bottom-1 scale-x-[-1]'>
              <svg width="27" height="28" viewBox="0 0 27 28" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M7.09989 21.8499C11.6643 16.8499 10.65 0.849945 10.65 0.849945L26.8789 20.3499C20.7931 25.3499 11.6643 28.8499 -0.000267029 27.3499C-0.000267029 27.3499 2.5355 26.8499 7.09989 21.8499Z" fill="#8570FF"/>
              </svg>
            </span>
          )}
          <div className='flex flex-col'>
            <span className={`text-sm leading-relaxed ${message.isUser ? 'text-white' : 'text-gray-300'}`}>
              {message.message}
            </span>
            <span className={`flex justify-end w-full text-xs mt-1 ${message.isUser ? 'text-gray-300' : 'text-gray-400'}`}>
              {message.time}
            </span>
          </div>
        </div>
      </div>
    </div>
  );
}
