import { Iconify } from "@/components/ui";

interface MessageInputProps {
  value: string;
  onChange: (value: string) => void;
  onSend: () => void;
  onKeyPress: (e: React.KeyboardEvent) => void;
}

export default function MessageInput({ value, onChange, onSend, onKeyPress }: MessageInputProps) {
  return (
    <div className="py-4 border-t border-white/5">
      <div className="mb-4">
        <label className="block text-gray-400 text-sm mb-2">Cevapla</label>
        <textarea
          value={value}
          onChange={(e) => onChange(e.target.value)}
          onKeyPress={onKeyPress}
          placeholder="Mesajınız"
          rows={3}
          className="w-full bg-base-2 text-white px-4 py-3 rounded-xl border border-white/5 focus:border-primary/50 focus:outline-none transition-colors resize-none"
        />
      </div>

      <div className="flex items-center gap-3">
        <button className="bg-base-2 flex items-center justify-center hover:bg-base-3 text-gray-400 hover:text-white px-4 py-2.5 rounded-xl border border-white/5 transition-colors">
          <Iconify icon="mdi:file" size={20} />
          <span className="text-sm">Dosya Seç</span>
        </button>
        <button className="bg-base-2 flex items-center justify-center hover:bg-base-3 text-gray-400 hover:text-white px-4 py-2.5 rounded-xl border border-white/5 transition-colors">
          <Iconify icon="mdi:file-cancel" size={20} />
        </button>
        <button
          onClick={onSend}
          disabled={!value.trim()}
          className="ml-auto bg-primary hover:bg-primary/90 text-white px-8 py-2.5 rounded-xl font-medium transition-colors disabled:opacity-50 disabled:cursor-not-allowed"
        >
          Gönder
        </button>
      </div>
    </div>
  );
}
