'use client'

import { useState } from "react";
import { useRouter } from "next/navigation";
import { Button, Input, Iconify } from "@/components/ui";
import { Footer } from "@/components/layout";

export default function CreateSupportTicketPage() {
  const router = useRouter();
  const [formData, setFormData] = useState({
    title: '',
    subject: '',
    files: [] as File[]
  });

  const handleSubmit = () => {
    console.log('Ticket created:', formData);
    // API call yapılacak
    router.push('/support');
  };

  const handleFileChange = (e: React.ChangeEvent<HTMLInputElement>) => {
    if (e.target.files) {
      const filesArray = Array.from(e.target.files);
      setFormData({ ...formData, files: filesArray });
    }
  };

  return (
    <div className="min-h-screen h-screen overflow-y-auto w-full bg-base-1 pt-20 pb-16">
      <div className="max-w-3xl mx-auto px-4 lg:px-6">
        {/* Header */}
        <div className="flex items-center gap-4 mb-8">
          <Iconify icon="mdi:headphones" size={40} className="text-white" />
          <h1 className="text-white text-2xl lg:text-3xl font-bold">Destek Talebi Oluştur</h1>
        </div>

        {/* Form */}
        <div className="bg-base-2 rounded-3xl p-6 lg:p-8">
          <div className="space-y-6">
            {/* Başlık */}
            <div>
              <label className="block text-white text-sm font-medium mb-2">Başlık</label>
              <Input
                type="text"
                placeholder="Başlık Girin"
                value={formData.title}
                onChange={(e) => setFormData({ ...formData, title: e.target.value })}
                containerClassName="w-full"
              />
            </div>

            {/* Konu */}
            <div>
              <label className="block text-white text-sm font-medium mb-2">Konu</label>
              <textarea
                placeholder="Konu Nedir"
                value={formData.subject}
                onChange={(e) => setFormData({ ...formData, subject: e.target.value })}
                rows={6}
                className="w-full bg-base-3 text-white px-4 py-3 rounded-xl border border-white/5 focus:border-primary/50 focus:outline-none transition-colors resize-none"
              />
            </div>

            {/* Dosya Seçimi */}
            <div>
              <label className="block text-white text-sm font-medium mb-2">Dosya</label>
              <div className="flex gap-3">
                <label className="flex-1 cursor-pointer">
                  <input
                    type="file"
                    onChange={handleFileChange}
                    className="hidden"
                    multiple
                  />
                  <div className="bg-base-3 hover:bg-base-3/80 text-gray-400 px-4 py-3 rounded-xl border border-white/5 transition-colors flex items-center justify-center gap-2">
                    <Iconify icon="mdi:file" size={20} />
                    <span className="text-sm">Dosya Seç</span>
                  </div>
                </label>
                <button className="bg-base-3 hover:bg-base-3/80 text-gray-400 px-4 py-3 rounded-xl border border-white/5 transition-colors">
                  <Iconify icon="mdi:file-cancel" size={20} />
                </button>
              </div>
              {formData.files.length > 0 && (
                <p className="text-gray-400 text-sm mt-2">
                  {formData.files.length} dosya seçildi
                </p>
              )}
            </div>

            {/* Gönder Butonu */}
            <Button
              variant="primary"
              size="lg"
              fullWidth
              onClick={handleSubmit}
              className="mt-4"
            >
              Gönder
            </Button>
          </div>
        </div>
      </div>

      <Footer />
    </div>
  );
}
