'use client'

import { useState } from "react";
import { useRouter } from "next/navigation";
import { Button, Input, Icon, Modal } from "@/components/ui";
import { StatCard } from "../../_components";
import { useWithdrawForm } from "@/hooks";

export default function USDCWithdrawPage() {
  const router = useRouter();
  const [balance] = useState<string>("23.540₺");
  const [showVerificationModal, setShowVerificationModal] = useState(false);

  const { formData, errors, updateField, setAmount, useAllBalance, handleSubmit } = useWithdrawForm({
    balance,
    onSubmit: () => setShowVerificationModal(true)
  });

  const handleModalClose = () => {
    setShowVerificationModal(false);
  };

  const handleGoToSettings = () => {
    setShowVerificationModal(false);
    router.push('/settings');
  };

  return (
    <div className="min-h-screen w-full mt-14 bg-base-1 p-4 lg:p-6">
      {/* Header */}
      <div className="w-full mx-auto mb-6">
     
        <div className="flex items-center gap-4">
          <div className="w-16 h-16 bg-base-2 text-white rounded-2xl flex items-center justify-center">
            <Icon name="token-branded:usdt" size={32}  />
          </div>
          <div>
            <h1 className="text-2xl font-bold text-white mb-1">USDC Çekim</h1>
            <p className="text-gray-400 text-sm">Kripto USDC ile Çekim</p>
          </div>
        </div>
      </div>
      <div className="w-full border-b border-white/10 mb-6" />

      {/* Çekilebilir Bakiye Kartı */}
      <div className="bg-base-2 rounded-3xl p-6 mb-6">
        <div className="flex items-center gap-3 mb-2">
          <Icon name="si:money-fill" size={24}/>
          <span className="text-gray-400 text-sm">Çekilebilir Bakiye</span>
        </div>
        <h2 className="text-4xl font-bold text-primary mb-4">{balance}</h2>
      </div>

      {/* Main Content */}
      <div className="w-full mx-auto grid grid-cols-1 lg:grid-cols-2 gap-6">
        {/* Sol Taraf - Form */}
        <div className="bg-base-2 rounded-3xl p-6 lg:p-8">
          <h2 className="text-xl font-semibold text-white mb-6">İşlem</h2>

          <div className="space-y-5">
            {/* Cüzdan Adresiniz */}
            <Input
              label="Cüzdan Adresiniz"
              type="text"
              placeholder="Cüzdan"
              value={formData.walletAddress}
              onChange={(e) => updateField('walletAddress', e.target.value)}
              containerClassName="w-full"
              error={errors.walletAddress}
            />

            {/* Tutar Giriniz */}
            <div className="relative">
              <Input
                label="Tutar Giriniz"
                type="text"
                placeholder="Tutar"
                value={formData.amount}
                onChange={(e) => setAmount(e.target.value)}
                containerClassName="w-full"
                error={errors.amount}
              />
              <button
                type="button"
                onClick={useAllBalance}
                className="absolute right-0 top-1 underline text-xs text-primary hover:text-primary/80 transition-colors font-medium"
              >
                Tüm Bakiye
              </button>
            </div>

            {/* Gönder Butonu */}
            <Button
              variant="primary"
              size="lg"
              fullWidth
              onClick={() => handleSubmit('crypto')}
              className="mt-6"
            >
              Gönder
            </Button>
          </div>
        </div>

        {/* Sağ Taraf - Bilgilendirme */}
        <div className="bg-base-2 rounded-3xl p-6 lg:p-8">
          <h2 className="text-lg font-semibold text-primary mb-4">
            Cenoa Bank Çekim Talepleri Hakkında Önemli Bilgilendirme
          </h2>

          <div className="space-y-4 text-gray-300 text-sm leading-relaxed">
            <p>
              Cenoa Bank hesabınıza USDC (USD Coin) çekim işlemi yaparken lütfen aşağıdaki önemli noktaları dikkatlice okuyunuz.
            </p>
          </div>
        </div>
      </div>

      {/* Verification Modal */}
      <Modal isOpen={showVerificationModal} onClose={handleModalClose}>
        <div className="p-6 text-center space-y-6">
          {/* Warning Icon */}
          <div className="flex justify-center">
            <StatCard
              icon="material-symbols:warning-outline"
              size="lg"
              color="primary"
            />
          </div>

          <div className="space-y-2">
            <p className="text-sm text-white/70">
              E-posta veya telefon doğrulaması yapmanız gerekiyor.
            </p>
          </div>
          
          <Button 
            variant="primary" 
            size="md" 
            fullWidth 
            onClick={handleGoToSettings}
          >
            Ayarlara Git
          </Button>
        </div>
      </Modal>
    </div>
  );
}
