import React from 'react'
import { Iconify } from '@/components/ui'

interface FeatureItem {
  icon: string
  title: string
  description: string
}

interface FeatureSectionProps {
  features?: FeatureItem[]
  className?: string
}

const defaultFeatures: FeatureItem[] = [
  {
    icon: "tdesign:money",
    title: "Kazancınızı Katlayın",
    description: "Diğer platformlardan çok daha fazla gelir elde edin. Bizim önceliğimiz, kazancınızı en üst seviyeye çıkarmak."
  },
  {
    icon: "charm:shield-tick",
    title: "Hızlı Ödeme",
    description: "Paranı anında çek! Minimum çekim tutarı bulunduğun bölgeye göre 5$ – 20$ arasında değişir ve ödemeler birkaç dakika içinde hesabına geçer."
  },
  {
    icon: "mdi:gift-outline",
    title: "Her Gün Ekstra Kazanç",
    description: "Günlük bonus merdiveninde adım adım yüksel, liderler listesine gir veya kesintisiz serini koruyarak ekstra ödülleri ücretsiz kazan."
  },
  {
    icon: "uil:calender",
    title: "Haftalık Görevler",
    description: "Haftalık görevlerini tamamla, özel rozetler kazan ve ekstra ödüllerin kilidini aç. Ne kadar aktif olursan, kazancın o kadar artar!"
  }
]

export function FeatureSection({ 
  features = defaultFeatures, 
  className = "" 
}: FeatureSectionProps) {
  return (
    <section className={`w-full  max-w-6xl px-4 ${className}`}>
      <h2 className='py-12 text-3xl text-center font-semibold'>Para kazanmanın bir numaralı adresiyiz. İşte sebebi</h2>
      <div className='w-full grid grid-cols-2 sm:grid-cols-2 lg:grid-cols-4 gap-4 md:gap-6'>
        {features.map((feature, index) => (
          <div 
            key={index}
            className='w-full border border-white/5 bg-white/3 rounded-2xl md:rounded-3xl pb-12 md:pb-18 pt-16 md:pt-24 px-4 md:px-6 flex flex-col space-y-2 items-center justify-start hover:bg-white/5 transition-colors duration-300'
          >
            <Iconify 
              icon={feature.icon} 
              size={55} 
              className="mx-auto text-primary md:text-[65px]" 
            />
            <div className='text-base md:text-lg w-full font-semibold text-center text-white'>
              {feature.title}
            </div>
            <div className='text-xs md:text-sm w-full font-normal text-white/70 text-center'>
              {feature.description}
            </div>
          </div>
        ))}
      </div>
    </section>
  )
}