'use client'

import { useState } from "react";
import { Iconify } from "@/components/ui";
import Image from "next/image";
import Link from "next/link";

// Mock blog data
const blogPosts = [
  {
    id: '1',
    slug: 'instagram-sosyal-medyanin-degismeyen-gucu',
    title: 'Instagram: Sosyal Medyanın Değişmeyen Gücü',
    excerpt: 'Instagram, görsel odaklı yapısıyla kullanıcıların kendini ifade etme biçimini kökten değiştirdi. Reels, hikayeler ve alışveriş özellikleriyle artık yalnızca bir paylaşım platformu değil, aynı zamanda markaların da vazgeçilmez dijital vitrinlerinden biri.',
    featuredImage: '/assets/images/blog/instagram.jpg',
    category: { name: 'Yeni', color: 'bg-primary' },
    author: { name: 'Ayşe Demir', avatar: '/assets/images/avatars/ayse.jpg' },
    publishedAt: '2 Jul 2025',
    readTime: 8
  },
  {
    id: '2',
    slug: 'spotify-muzige-sinirsiz-erisim',
    title: 'Spotify: Müziğe Sınırsız Erişim',
    excerpt: 'Spotify, milyonlarca şarkıya erişim imkanıyla müzik dinleme alışkanlıklarımızı yeniden tanımladı. Kişisel çalma listeleri, keşif algoritması ve podcast entegrasyonlarıyla müzik dünyasında lider konumunu koruyor.',
    featuredImage: '/assets/images/blog/spotify.jpg',
    category: { name: 'Yeni', color: 'bg-primary' },
    author: { name: 'Ayşe Demir', avatar: '/assets/images/avatars/ayse.jpg' },
    publishedAt: '2 Jul 2025',
    readTime: 6
  },
  {
    id: '3',
    slug: 'is-bankasi-yenilikci-bankacilik-cozumleri',
    title: 'İş Bankası: Yenilikçi Bankacılık Çözümleri',
    excerpt: 'Türkiye\'nin köklü bankalarından İş Bankası, dijitalleşmeye yaptığı yatırımlarla bankacılık hizmetlerini yeniden şekillendiriyor. Mobil uygulaması ve müşteri odaklı yaklaşımıyla sektörde öne çıkıyor.',
    featuredImage: '/assets/images/blog/isbank.jpg',
    category: { name: 'Yeni', color: 'bg-primary' },
    author: { name: 'Ayşe Demir', avatar: '/assets/images/avatars/ayse.jpg' },
    publishedAt: '2 Jul 2025',
    readTime: 5
  },
  {
    id: '4',
    slug: 'film-sektoru-dijital-donusumun-etkisi',
    title: 'Film Sektörü: Dijital Dönüşümün Etkisi',
    excerpt: 'Streaming platformlarının yükselişiyle film sektörü büyük bir dönüşüm yaşıyor. Geleneksel sinema salonlarından dijital platformlara geçiş, içerik üretimi ve tüketimi modellerini değiştiriyor.',
    featuredImage: '/assets/images/blog/film.jpg',
    category: { name: 'Yeni', color: 'bg-primary' },
    author: { name: 'Ayşe Demir', avatar: '/assets/images/avatars/ayse.jpg' },
    publishedAt: '2 Jul 2025',
    readTime: 7
  },
  {
    id: '5',
    slug: 'shuffle-muzixin-surpriz-yolu',
    title: 'Shuffle: Müziğin Sürpriz Yolu',
    excerpt: 'Shuffle özelliği, dinleyicilere beklenmedik müzik yolculukları yaşatıyor. Alışılmış listelerin dışına çıkarak, yeni keşifler ve sürpriz karşılaşmalar sunuyor.',
    featuredImage: '/assets/images/blog/shuffle.jpg',
    category: { name: 'Yeni', color: 'bg-primary' },
    author: { name: 'Ayşe Demir', avatar: '/assets/images/avatars/ayse.jpg' },
    publishedAt: '2 Jul 2025',
    readTime: 4
  }
];

export default function BlogPage() {
  const [searchQuery, setSearchQuery] = useState('');
  const [featuredPost] = useState(blogPosts[0]);
  const otherPosts = blogPosts.slice(1);

  return (
    <div className="min-h-screen w-full bg-base-1 pt-20 pb-16">
      <div className="container mx-auto px-4 lg:px-6">
        {/* Search Bar */}
        <div className="max-w-2xl mx-auto mb-12">
          <div className="relative">
            <Iconify 
              icon="mdi:magnify" 
              size={20} 
              className="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400"
            />
            <input
              type="text"
              placeholder="Ara..."
              value={searchQuery}
              onChange={(e) => setSearchQuery(e.target.value)}
              className="w-full bg-base-2 text-white pl-12 pr-4 py-3 rounded-xl border border-white/10 focus:border-primary/50 focus:outline-none transition-colors"
            />
          </div>
        </div>

        {/* Featured Post */}
        <div className="mb-12">
          <Link href={`/blog/${featuredPost.slug}`}>
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-8 items-center">
              {/* Left - Image */}
              <div className="relative aspect-[16/10] rounded-3xl overflow-hidden group">
                <Image
                  src={featuredPost.featuredImage}
                  alt={featuredPost.title}
                  fill
                  className="object-cover group-hover:scale-105 transition-transform duration-500"
                />
              </div>

              {/* Right - Content */}
              <div>
                <span className={`inline-block ${featuredPost.category.color} text-white text-sm px-4 py-1.5 rounded-full mb-4`}>
                  {featuredPost.category.name}
                </span>
                <span className="text-gray-400 text-sm ml-3">{featuredPost.readTime} dk okuma süresi</span>

                <h1 className="text-white text-3xl lg:text-4xl font-bold mb-4 hover:text-primary transition-colors">
                  {featuredPost.title}
                </h1>

                <p className="text-gray-300 text-base leading-relaxed mb-6">
                  {featuredPost.excerpt}
                </p>

                <div className="flex items-center gap-3 text-sm text-primary hover:underline">
                  <span>Devamını Oku</span>
                  <Iconify icon="mdi:arrow-right" size={20} />
                </div>
              </div>
            </div>
          </Link>
        </div>

        {/* Other Posts Grid */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
          {otherPosts.map((post) => (
            <Link key={post.id} href={`/blog/${post.slug}`}>
              <div className="bg-base-2 rounded-3xl overflow-hidden hover:bg-base-3 transition-all group">
                {/* Image */}
                <div className="relative aspect-video overflow-hidden">
                  <Image
                    src={post.featuredImage}
                    alt={post.title}
                    fill
                    className="object-cover group-hover:scale-105 transition-transform duration-500"
                  />
                </div>

                {/* Content */}
                <div className="p-5">
                  {/* Author & Date */}
                  <div className="flex items-center gap-2 mb-3">
                    <span className="text-gray-400 text-sm">{post.author.name}</span>
                    <span className="text-gray-600">•</span>
                    <span className="text-gray-400 text-sm">{post.publishedAt}</span>
                  </div>

                  {/* Title */}
                  <h3 className="text-white font-semibold text-lg mb-3 line-clamp-2 group-hover:text-primary transition-colors">
                    {post.title}
                  </h3>

                  {/* Excerpt */}
                  <p className="text-gray-400 text-sm line-clamp-3 mb-4">
                    {post.excerpt}
                  </p>

                  {/* Read More */}
                  <div className="flex items-center gap-2 text-sm text-primary">
                    <span>Devamını Oku</span>
                    <Iconify icon="mdi:arrow-right" size={18} />
                  </div>
                </div>
              </div>
            </Link>
          ))}
        </div>
      </div>
    </div>
  );
}
