'use client'

import { useState } from "react";
import { Iconify } from "@/components/ui";

interface FAQItem {
  id: number;
  question: string;
  answer: string;
}

const faqData: FAQItem[] = [
  {
    id: 1,
    question: "Kimler Kiqro'ya üye olmadan kullanabilir?",
    answer: "Kiqro platformuna üye olmadan erişim sağlayamazsınız. Platformumuzun tüm özelliklerinden faydalanabilmek için üyelik oluşturmanız gerekmektedir."
  },
  {
    id: 2,
    question: "Kiqro'ya  nasıl üye olabilirim?",
    answer: "Turkey grants visa exemption to certain countries. Citizens of some EU countries, Russia, Ukraine, and Georgia, among others, can enter Turkey without a visa for a specific period. For the latest list, check the official websites of the Turkish Ministry of Foreign Affairs or Immigration Office."
  },
  {
    id: 3,
    question: "Kimler Kiqro'ya  üye olmadan kullanabilir?",
    answer: "Kiqro platformuna üye olmadan erişim sağlayamazsınız. Platformumuzun tüm özelliklerinden faydalanabilmek için üyelik oluşturmanız gerekmektedir."
  },
  {
    id: 4,
    question: "Kimler Kiqro'ya üye olmadan kullanabilir?",
    answer: "Kiqro platformuna üye olmadan erişim sağlayamazsınız. Platformumuzun tüm özelliklerinden faydalanabilmek için üyelik oluşturmanız gerekmektedir."
  },
  {
    id: 5,
    question: "Görevleri tamamladıktan sonra ne kadar sürede ödeme alırım?",
    answer: "Görev onaylandıktan sonra ödemeniz hesabınıza 24-48 saat içerisinde yansıtılır. Ödemelerinizi cüzdanınızdan takip edebilirsiniz."
  },
  {
    id: 6,
    question: "Hangi ödeme yöntemlerini kullanabilirim?",
    answer: "Papara, Havale/EFT ve USDC gibi çeşitli ödeme yöntemlerini destekliyoruz. İstediğiniz yöntemi seçerek güvenli bir şekilde çekim yapabilirsiniz."
  },
  {
    id: 7,
    question: "Minimum çekim tutarı nedir?",
    answer: "Minimum çekim tutarı 50 TL'dir. Bu tutarın üzerinde olan bakiyenizi istediğiniz zaman çekebilirsiniz."
  },
  {
    id: 8,
    question: "Referans sistemi nasıl çalışır?",
    answer: "Referans linkinizi arkadaşlarınızla paylaşarak onların kazançlarından komisyon alabilirsiniz. Detaylı bilgi için Referanslar sayfasını ziyaret edebilirsiniz."
  }
];

export default function FAQPage() {
  const [openItems, setOpenItems] = useState<number[]>([2]); // 2. soru başlangıçta açık

  const toggleItem = (id: number) => {
    if (openItems.includes(id)) {
      setOpenItems(openItems.filter(item => item !== id));
    } else {
      setOpenItems([...openItems, id]);
    }
  };

  return (
    <div className="min-h-screen w-full mt-24 bg-base-1 pt-20 pb-16">
      <div className="container mx-auto px-4 lg:px-6 max-w-5xl">
        {/* Header */}
        <div className="text-center mb-12">
          <h1 className="text-white text-xl lg:text-3xl font-bold mb-4">
            Kiqro Hakkında Sıkça Sorulan Sorular
          </h1>
          <p className="text-gray-400 text-base lg:text-lg">
            Uygulamamızdaki sorgu sistemi sayesinde başvurunuzun durumunu hızlı ve kolay bir şekilde kontrol edebilirsiniz.
          </p>
        </div>

        {/* FAQ Items */}
        <div className="space-y-4">
          {faqData.map((item) => {
            const isOpen = openItems.includes(item.id);
            
            return (
              <div
                key={item.id}
                className=" rounded-2xl border border-white/2 overflow-hidden transition-all"
              >
                {/* Question */}
                <button
                  onClick={() => toggleItem(item.id)}
                  className="w-full flex items-center justify-between gap-4 p-6 text-left  transition-colors"
                >
                  {/* Number Badge */}
                  <div className="flex items-center gap-4 flex-1">
                    <div className="w-12 h-12 bg-base-3 rounded-xl flex items-center justify-center flex-shrink-0">
                      <span className="text-white font-semibold text-lg">{item.id}</span>
                    </div>
                    
                    {/* Question Text */}
                    <h3 className="text-white text-base lg:text-lg font-medium">
                      {item.question}
                    </h3>
                  </div>

                  {/* Toggle Button */}
                  <div className="flex items-center gap-2 flex-shrink-0">
                    <span className="text-gray-400 text-sm hidden sm:block">
                      Görüntüle
                    </span>
                    <div className={`transform transition-transform duration-300 ${isOpen ? 'rotate-180' : ''}`}>
                      <Iconify 
                        icon="mdi:chevron-down" 
                        size={24} 
                        className="text-gray-400"
                      />
                    </div>
                  </div>
                </button>

                {/* Answer */}
                <div
                  className={`transition-all mx-4 duration-300 ease-in-out ${
                    isOpen ? 'max-h-96 opacity-100 border-t border-white/2' : 'max-h-0 opacity-0'
                  } overflow-hidden`}
                >
                  <div className="px-6 pb-6 pt-2">
                    <div className="pl-16">
                      <p className="text-gray-300 text-sm lg:text-base leading-relaxed">
                        {item.answer}
                      </p>
                    </div>
                  </div>
                </div>
              </div>
            );
          })}
        </div>

        {/* Bottom Info */}
        <div className="mt-12 text-center">
          <p className="text-gray-400 text-base mb-4">
            Sorunuz burada mı yok? Bizimle iletişime geçin.
          </p>
          <a 
            href="/contact" 
            className="inline-flex items-center gap-2 bg-primary hover:bg-primary/90 text-white px-6 py-3 rounded-xl font-medium transition-colors"
          >
            <span>İletişime Geç</span>
            <Iconify icon="mdi:arrow-right" size={20} />
          </a>
        </div>
      </div>
    </div>
  );
}
