'use client'

export default function PrivacyPolicyPage() {
  return (
    <div className="min-h-screen w-full  px-4 py-20">
      <div className="max-w-4xl mx-auto">
        {/* Header */}
        <div className="mb-8">
          <h1 className="text-white text-3xl lg:text-4xl font-bold mb-3">
            Kiqro - Müzik Dinle Kazan Uygulaması Gizlilik Sözleşmesi
          </h1>
          <p className="text-gray-400 text-sm italic">
            Last reviewed on [18.03.2024]
          </p>
        </div>

        {/* Content */}
        <div className="prose prose-invert max-w-none">
          {/* 1. Giriş */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">1. Giriş</h2>
            <p className="text-gray-300 leading-relaxed mb-4">
              Kiqro Cash olarak kullanıcılarımızın kişisel verilerinin gizliliğine ve güvenliğine en yüksek önemi veriyoruz. Bu Gizlilik Sözleşmesi, uygulamamız aracılığıyla toplanan bilgilerin hangi amaçlarla işlendiğini, nasıl saklandığını ve kullanıcıların bu bilgiler üzerindeki haklarını açıklamaktadır.
            </p>
            <p className="text-gray-300 leading-relaxed">
              Uygulamayı indirip kullanarak bu sözleşmede yer alan hüküm ve koşulları kabul etmiş olursunuz.
            </p>
          </section>

          {/* 2. Toplanan Veriler */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">2. Toplanan Veriler</h2>
            <p className="text-gray-300 leading-relaxed mb-4">
              Uygulamamız kullanımınız sırasında aşağıdaki verileri toplayabiliriz:
            </p>
            <ul className="list-disc list-inside text-gray-300 space-y-2 ml-4">
              <li><strong className="text-white">Kimlik Bilgileri:</strong> Ad, soyad, doğum tarihi, kullanıcı adı.</li>
              <li><strong className="text-white">İletişim Bilgileri:</strong> Telefon numarası, e-posta adresi.</li>
              <li><strong className="text-white">Cihaz Bilgileri:</strong> IP adresi, işletim sistemi, cihaz modeli, tarayıcı türü.</li>
              <li><strong className="text-white">Konum Verileri:</strong> Kullanıcının izniyle anlık veya yaklaşık konum bilgisi.</li>
              <li><strong className="text-white">Uygulama Kullanım Verileri:</strong> Dinlenen müzikler, olurum süresi, kazanılan puanlar.</li>
              <li><strong className="text-white">Ödeme Bilgileri:</strong> Banka/ödeme sağlayıcıya aktarılan zorunlu bilgiler.</li>
            </ul>
          </section>

          {/* 3. Verilerin Kullanım Amaçları */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">3. Verilerin Kullanım Amaçları</h2>
            <p className="text-gray-300 leading-relaxed mb-4">
              Toplanan kişisel veriler aşağıdaki amaçlarla kullanılmaktadır:
            </p>
            <ul className="list-disc list-inside text-gray-300 space-y-2 ml-4">
              <li>Hizmetin sunulması ve iyileştirilmesi,</li>
              <li>Kullanıcıların müzik dinleme aktivitelerine göre ödül kazandırılması,</li>
              <li>Güvenlik, dolandırıcılık tespiti ve kötüye kullanımın engellenmesi,</li>
              <li>Kullanıcı desteği ve iletişim sağlanması,</li>
              <li>Yasal yükümlülüklerin yerine getirilmesi,</li>
              <li>Reklam ve kişiselleştirilmiş içerik sunulması (onay vermeniz halinde).</li>
            </ul>
          </section>

          {/* 4. Verilerin Paylaşılması */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">4. Verilerin Paylaşılması</h2>
            <p className="text-gray-300 leading-relaxed mb-4">
              Kullanıcı verileri aşağıdaki durumlarda üçüncü kişilerle paylaşılabilir:
            </p>
            <ul className="list-disc list-inside text-gray-300 space-y-2 ml-4">
              <li><strong className="text-white">Hizmet Sağlayıcılar:</strong> Ödeme kuruluşları, reklam ağları, müşteri destek hizmetleri.</li>
              <li><strong className="text-white">Yasal Yükümlülükler:</strong> Mahkeme kararları, resmi makam talepleri.</li>
              <li><strong className="text-white">İş Ortakları:</strong> Kampanyalar ve promosyonlar kapsamında işbirliği yapılan şirketler.</li>
              <li><strong className="text-white">Anonimleştirilmiş Veriler:</strong> İstatistiksel analizler için kimliği belirlenemeyecek şekilde.</li>
            </ul>
          </section>

          {/* 5. Veri Saklama Süresi */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">5. Veri Saklama Süresi</h2>
            <p className="text-gray-300 leading-relaxed mb-4">
              Kişisel verileriniz, ilgili amaç için gerekli olduğu sürece saklanacaktır. Hesabınızı sildiğinizde, yasal zorunluluklar dışında verileriniz kalıcı olarak silinecektir.
            </p>
            <p className="text-gray-300 leading-relaxed">
              Ancak, yasalar gereği bazı veriler belirli bir süre boyunca arşivlenmek zorunda olabilir.
            </p>
          </section>

          {/* 6. Kullanıcı Hakları */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">6. Kullanıcı Hakları</h2>
            <p className="text-gray-300 leading-relaxed mb-4">
              KVKK ve GDPR kapsamında kullanıcılarımız aşağıdaki haklara sahiptir:
            </p>
            <ul className="list-disc list-inside text-gray-300 space-y-2 ml-4">
              <li>Kişisel verilerinizin işlenip işlenmediğini öğrenme,</li>
              <li>İşlenen verilere erişim talep etme,</li>
              <li>Hatalı verilerin düzeltilmesini isteme,</li>
              <li>Belirli koşullarda verilerin silinmesini veya yok edilmesini talep etme,</li>
              <li>Pazarlama iletişimlerinden çıkma,</li>
              <li>Otomatik karar alma süreçlerine itiraz etme.</li>
            </ul>
            <p className="text-gray-300 leading-relaxed mt-4">
              Bu haklarınızı kullanmak için <strong className="text-primary">destek@kiqro.com</strong> adresine başvurabilirsiniz.
            </p>
          </section>

          {/* 7. Güvenlik Önlemleri */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">7. Güvenlik Önlemleri</h2>
            <p className="text-gray-300 leading-relaxed mb-4">
              Verilerinizin güvenliğini sağlamak için teknik ve idari önlemler alıyoruz:
            </p>
            <ul className="list-disc list-inside text-gray-300 space-y-2 ml-4">
              <li>SSL/TLS şifreleme ile veri aktarımı,</li>
              <li>Güvenli sunucu altyapısı,</li>
              <li>Düzenli güvenlik testleri ve güncellemeleri,</li>
              <li>Sınırlı erişim kontrolleri.</li>
            </ul>
          </section>

          {/* 8. Çerezler ve İzleme Teknolojileri */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">8. Çerezler ve İzleme Teknolojileri</h2>
            <p className="text-gray-300 leading-relaxed mb-4">
              Uygulamamız, kullanıcı deneyimini iyileştirmek için çerezler ve benzer teknolojiler kullanabilir. Çerez tercihinizi ayarlardan yönetebilirsiniz.
            </p>
          </section>

          {/* 9. Üçüncü Taraf Bağlantılar */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">9. Üçüncü Taraf Bağlantılar</h2>
            <p className="text-gray-300 leading-relaxed">
              Uygulamamız, üçüncü taraf web sitelerine veya hizmetlerine bağlantılar içerebilir. Bu sitelerin gizlilik politikalarından sorumlu değiliz.
            </p>
          </section>

          {/* 10. Değişiklikler */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">10. Değişiklikler</h2>
            <p className="text-gray-300 leading-relaxed">
              Bu gizlilik sözleşmesi zaman zaman güncellenebilir. Önemli değişiklikler uygulama içi bildirimler veya e-posta yoluyla size bildirilecektir.
            </p>
          </section>

          {/* 11. İletişim */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">11. İletişim</h2>
            <p className="text-gray-300 leading-relaxed mb-2">
              Gizlilik sözleşmesi ile ilgili sorularınız için:
            </p>
            <p className="text-gray-300 leading-relaxed">
              <strong className="text-white">E-posta:</strong> <span className="text-primary">destek@kiqro.com</span><br />
              <strong className="text-white">Adres:</strong> Kiqro Cash, İstanbul, Türkiye
            </p>
          </section>
        </div>
      </div>
    </div>
  );
}
