import type { Metadata } from "next";
import { Poppins } from "next/font/google";
import "./globals.css";
import NavigationLoader from "@/components/providers/NavigationLoader";

const poppins = Poppins({
  variable: "--font-poppins",
  subsets: ["latin"],
  weight: ["300", "400", "500", "600", "700", "800"],
  display: "swap",
});

export const metadata: Metadata = {
  title: "Kiqro - Görev Yaparak Para Kazan",
  description: "Kiqro ile mikro ve makro görevler yaparak para kazanın. Anket doldur, dinle kazan, referans sistemi ile ek gelir elde et.",
  keywords: ["para kazanma", "görev", "anket", "mikro görev", "referans", "online kazanç"],
  authors: [{ name: "Kiqro Team" }],
  creator: "Kiqro",
  publisher: "Kiqro",
  formatDetection: {
    email: false,
    address: false,
    telephone: false,
  },
  openGraph: {
    type: "website",
    locale: "tr_TR",
    url: "https://www.kiqro.com",
    siteName: "Kiqro",
    title: "Kiqro - Görev Yaparak Para Kazan",
    description: "Kiqro ile mikro ve makro görevler yaparak para kazanın. Anket doldur, dinle kazan, referans sistemi ile ek gelir elde et.",
    images: [
      {
        url: "/og-image.jpg",
        width: 1200,
        height: 630,
        alt: "Kiqro - Görev Yaparak Para Kazan",
      },
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Kiqro - Görev Yaparak Para Kazan",
    description: "Kiqro ile mikro ve makro görevler yaparak para kazanın. Anket doldur, dinle kazan, referans sistemi ile ek gelir elde et.",
    images: ["/og-image.jpg"],
  },
  robots: {
    index: true,
    follow: true,
    googleBot: {
      index: true,
      follow: true,
      "max-video-preview": -1,
      "max-image-preview": "large",
      "max-snippet": -1,
    },
  },
  verification: {
    google: "your-google-site-verification",
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="tr" className="dark">
      <body className={`${poppins.variable}  font-sans antialiased`}>
        <NavigationLoader />
        {children}
      </body>
    </html>
  );
}
