'use client'

import React, { useState } from 'react'
import Image from 'next/image'
import Link from 'next/link'
import { cn } from '@/lib/utils'
import { Button, PlatformSelector, Iconify } from '../ui'
import { LoginModal, RegisterModal, ForgotPasswordModal } from '../sections'
import UserDropdown from './UserDropdown'

interface NavbarProps {
  className?: string
  variant?: 'default' | 'authenticated' | 'dashboard' | 'authenticated2'
  onMenuToggle?: () => void
  onLiveChatToggle?: () => void
}

const Navbar: React.FC<NavbarProps> = ({ className, variant = 'default', onLiveChatToggle }) => {
  const [isLoginModalOpen, setIsLoginModalOpen] = useState(false)
  const [isRegisterModalOpen, setIsRegisterModalOpen] = useState(false)
  const [isForgotPasswordModalOpen, setIsForgotPasswordModalOpen] = useState(false)

  const handleLoginClick = () => {
    setIsLoginModalOpen(true)
  }

  const handleRegisterClick = () => {
    setIsRegisterModalOpen(true)
  }

  const handleSwitchToRegister = () => {
    setIsLoginModalOpen(false)
    setIsRegisterModalOpen(true)
  }

  const handleSwitchToLogin = () => {
    setIsRegisterModalOpen(false)
    setIsLoginModalOpen(true)
  }

  const handleForgotPassword = () => {
    setIsLoginModalOpen(false)
    setIsForgotPasswordModalOpen(true)
  }

  const handleBackToLogin = () => {
    setIsForgotPasswordModalOpen(false)
    setIsLoginModalOpen(true)
  }
  // Default variant - Ana sayfa için (Giriş Yap ve Kayıt Ol butonları)
  if (variant === 'default') {
    return (
      <>
        <nav className={cn(
          'w-full bg-base-1/95 backdrop-blur-sm border-b border-primary/20',
          'fixed top-0 z-30',
          className
        )}>
          <div className="container mx-auto px-4 sm:px-6 lg:px-8">
            <div className="flex items-center justify-between h-16">
              {/* Logo */}
              <Link href="/" className="flex-shrink-0">
                <Image
                  src="/assets/logo.png"
                  alt="Kiqro Logo"
                  width={120}
                  height={40}
                  className="h-6 md:h-8 w-auto cursor-pointer"
                />
              </Link>

              {/* Navigation Buttons - Desktop */}
              <div className="hidden sm:flex items-center gap-3">
                <Button 
                  variant="outline" 
                  size="sm"
                  onClick={handleLoginClick}
                >
                  Giriş Yap
                </Button>
                <Button 
                  variant="primary" 
                  size="sm"
                  onClick={handleRegisterClick}
                >
                  Kayıt Ol
                </Button>
              </div>

              {/* Mobile Menu Button */}
              <button
                onClick={handleLoginClick}
                className="sm:hidden p-2 text-white"
              >
                <Iconify icon="mdi:account-circle" size={28} />
              </button>
            </div>
          </div>
        </nav>

        {/* Modals */}
        <LoginModal
          isOpen={isLoginModalOpen}
          onClose={() => setIsLoginModalOpen(false)}
          onSwitchToRegister={handleSwitchToRegister}
          onForgotPassword={handleForgotPassword}
        />
        
        <RegisterModal
          isOpen={isRegisterModalOpen}
          onClose={() => setIsRegisterModalOpen(false)}
          onSwitchToLogin={handleSwitchToLogin}
        />

        <ForgotPasswordModal
          isOpen={isForgotPasswordModalOpen}
          onClose={() => setIsForgotPasswordModalOpen(false)}
          onBackToLogin={handleBackToLogin}
        />
      </>
    )
  }

  // Authenticated variant - Kullanıcı giriş yaptıktan sonra (Ara... butonlu)
  if (variant === 'authenticated') {
    return (
      <nav className={cn(
        'w-full bg-base-1/95 backdrop-blur-sm border-b border-primary/20',
        'fixed top-0 z-30',
        className
      )}>
        <div className="mx-auto px-3 lg:px-3">
          <div className="flex items-center justify-between h-16">
            {/* Logo - Always visible */}
            <div className='flex gap-30'>
            <Link href="/home" className="flex-shrink-0">
              <Image
                src="/assets/logo.png"
                alt="Kiqro Logo"
                width={120}
                height={40}
                className="h-6 md:h-8 w-auto cursor-pointer"
              />
            </Link>


        <div className='hidden md:block'> <PlatformSelector /></div>
           
            </div>

            {/* Right Section - Hidden on mobile except hamburger */}
            <div className="flex items-center gap-2 md:gap-4">
              {/* Search Bar - Hidden on mobile */}
              <div className="hidden md:block relative">
                <input
                  type="text"
                  placeholder="Ara..."
                  className="w-40 lg:w-64 px-3 lg:px-4 py-2 bg-base-2 border border-base-3 rounded-lg text-sm text-white placeholder-gray-400 focus:outline-none focus:border-primary/50"
                />
              </div>

              {/* User Info - Hidden on mobile */}
              <div className="hidden lg:flex items-center gap-2 md:gap-4">
                {/* Balance Card */}
                <Link href="/wallet" className="flex items-center gap-3 bg-base-3 pl-3 rounded-lg hover:bg-base-3/80 transition-colors">
                  <span className="text-sm  font-medium text-white">12.331₺</span>
                  <div className="flex items-center justify-center">
                    <svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg">
<g filter="url(#filter0_di_1080_13873)">
<rect x="5.40039" y="5.39999" width="28" height="28" rx="5" fill="#8570FF" shape-rendering="crispEdges"/>
<rect x="5.65039" y="5.64999" width="27.5" height="27.5" rx="4.75" stroke="#B9ADFF" stroke-width="0.5" shape-rendering="crispEdges"/>
<path d="M24.3581 19.4C24.3581 19.5878 24.2834 19.768 24.1506 19.9009C24.0178 20.0337 23.8376 20.1083 23.6497 20.1083C23.4619 20.1083 23.2817 20.0337 23.1489 19.9009C23.016 19.768 22.9414 19.5878 22.9414 19.4C22.9414 19.2121 23.016 19.032 23.1489 18.8991C23.2817 18.7663 23.4619 18.6917 23.6497 18.6917C23.8376 18.6917 24.0178 18.7663 24.1506 18.8991C24.2834 19.032 24.3581 19.2121 24.3581 19.4Z" fill="white"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M17.9434 13.2021H20.1477C21.4497 13.2021 22.481 13.2021 23.2878 13.3105C24.1179 13.4224 24.7902 13.6575 25.3207 14.1874C25.9752 14.8426 26.1842 15.7195 26.2599 16.8578C26.6687 17.037 26.9775 17.4174 27.0108 17.899C27.0143 17.9423 27.0143 17.9883 27.0143 18.0308V20.7692C27.0143 20.8117 27.0143 20.8578 27.0115 20.9003C26.9775 21.3819 26.6687 21.763 26.2599 21.9429C26.1842 23.0805 25.9752 23.9574 25.3207 24.6126C24.7902 25.1425 24.1179 25.3776 23.2878 25.4895C22.4803 25.5979 21.4497 25.5979 20.1477 25.5979H17.9434C16.6415 25.5979 15.6102 25.5979 14.8034 25.4895C13.9732 25.3776 13.301 25.1425 12.7704 24.6126C12.2406 24.0821 12.0054 23.4099 11.8935 22.5797C11.7852 21.7722 11.7852 20.7416 11.7852 19.4397V19.3603C11.7852 18.0584 11.7852 17.0271 11.8935 16.2203C12.0054 15.3901 12.2406 14.7179 12.7704 14.1874C13.301 13.6575 13.9732 13.4224 14.8034 13.3105C15.6109 13.2021 16.6415 13.2021 17.9434 13.2021ZM25.1854 22.0563H23.8127C22.2933 22.0563 20.9928 20.9031 20.9928 19.4C20.9928 17.8969 22.2933 16.7438 23.8119 16.7438H25.1847C25.1039 15.7939 24.9219 15.2917 24.5684 14.9389C24.2688 14.6393 23.858 14.4594 23.1454 14.3638C22.4179 14.266 21.4582 14.2646 20.1074 14.2646H17.9824C16.6316 14.2646 15.6725 14.266 14.9436 14.3638C14.2317 14.4594 13.8209 14.6393 13.5213 14.9389C13.2217 15.2385 13.0417 15.6494 12.9461 16.362C12.8484 17.0901 12.8469 18.0492 12.8469 19.4C12.8469 20.7508 12.8484 21.7106 12.9461 22.4388C13.0417 23.1506 13.2217 23.5615 13.5213 23.8611C13.8209 24.1607 14.2317 24.3406 14.9443 24.4363C15.6725 24.534 16.6316 24.5354 17.9824 24.5354H20.1074C21.4582 24.5354 22.4179 24.534 23.1461 24.4363C23.858 24.3406 24.2688 24.1607 24.5684 23.8611C24.9219 23.5083 25.1047 23.0068 25.1854 22.0563ZM14.6185 16.5667C14.6185 16.4258 14.6745 16.2906 14.7741 16.191C14.8737 16.0914 15.0088 16.0354 15.1497 16.0354H17.9831C18.124 16.0354 18.2591 16.0914 18.3587 16.191C18.4584 16.2906 18.5143 16.4258 18.5143 16.5667C18.5143 16.7076 18.4584 16.8427 18.3587 16.9423C18.2591 17.0419 18.124 17.0979 17.9831 17.0979H15.1497C15.0088 17.0979 14.8737 17.0419 14.7741 16.9423C14.6745 16.8427 14.6185 16.7076 14.6185 16.5667ZM25.7209 17.8063H23.8127C22.804 17.8063 22.0553 18.5564 22.0553 19.4C22.0553 20.2436 22.804 20.9938 23.8119 20.9938H25.7372C25.8831 20.9845 25.9462 20.8861 25.9511 20.8266V17.9734C25.9462 17.9139 25.8831 17.8155 25.7372 17.807L25.7209 17.8063Z" fill="white"/>
</g>
<defs>
<filter id="filter0_di_1080_13873" x="0.00039053" y="-6.19888e-06" width="38.8" height="38.8" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
<feFlood flood-opacity="0" result="BackgroundImageFix"/>
<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
<feOffset/>
<feGaussianBlur stdDeviation="2.7"/>
<feComposite in2="hardAlpha" operator="out"/>
<feColorMatrix type="matrix" values="0 0 0 0 0.72549 0 0 0 0 0.678431 0 0 0 0 1 0 0 0 0.7 0"/>
<feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_1080_13873"/>
<feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_1080_13873" result="shape"/>
<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
<feOffset dy="4"/>
<feGaussianBlur stdDeviation="3.9"/>
<feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1"/>
<feColorMatrix type="matrix" values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.55 0"/>
<feBlend mode="normal" in2="shape" result="effect2_innerShadow_1080_13873"/>
</filter>
</defs>
                </svg>
                   </div>
                </Link>
               
                <UserDropdown/>
               
              </div>

              {/* Mobile Menu Button - Right side, always visible on mobile */}
              <button
                onClick={onLiveChatToggle}
                className="lg:hidden p-2 text-white -mr-2 relative"
              >
                <Iconify icon="solar:chat-round-dots-linear" size={24} />
                <span className="absolute top-1.5 right-1.5 w-2 h-2 bg-green-500 rounded-full"></span>
              </button>
            </div>
          </div>
        </div>
      </nav>
    )
  }

  // Dashboard variant - Dashboard içinde kullanım için
   if (variant === 'authenticated2') {
    return (
      <nav className={cn(
        'w-full bg-base-1/95 backdrop-blur-sm border-b border-primary/20',
        'fixed top-0 z-20',
        className
      )}>
        <div className="mx-auto px-3 lg:px-3">
          <div className="flex items-center justify-between h-16">
            {/* Logo - Always visible */}
            <Link href="/home" className="flex-shrink-0">
              <Image
                src="/assets/logo.png"
                alt="Kiqro Logo"
                width={120}
                height={40}
                className="h-6 md:h-8 w-auto cursor-pointer"
              />
            </Link>

            {/* Right Section - Hidden on mobile except hamburger */}
            <div className="flex items-center gap-2 md:gap-4">
              {/* Search Bar - Hidden on mobile */}
              <div className="hidden md:block relative">
                <input
                  type="text"
                  placeholder="Ara..."
                  className="w-40 lg:w-64 px-3 lg:px-4 py-2 bg-base-2 border border-base-3 rounded-lg text-sm text-white placeholder-gray-400 focus:outline-none focus:border-primary/50"
                />
              </div>

              {/* User Info - Hidden on mobile */}
              <div className="hidden lg:flex items-center gap-2 md:gap-4">
                {/* Balance Card */}
                <Link href="/wallet" className="flex items-center gap-3 bg-base-3 pl-3 rounded-lg hover:bg-base-3/80 transition-colors">
                  <span className="text-sm  font-medium text-white">12.331₺</span>
                   <div className="flex items-center justify-center">
                    <svg width="39" height="39" viewBox="0 0 39 39" fill="none" xmlns="http://www.w3.org/2000/svg">
<g filter="url(#filter0_di_1080_13873)">
<rect x="5.40039" y="5.39999" width="28" height="28" rx="5" fill="#8570FF" shape-rendering="crispEdges"/>
<rect x="5.65039" y="5.64999" width="27.5" height="27.5" rx="4.75" stroke="#B9ADFF" stroke-width="0.5" shape-rendering="crispEdges"/>
<path d="M24.3581 19.4C24.3581 19.5878 24.2834 19.768 24.1506 19.9009C24.0178 20.0337 23.8376 20.1083 23.6497 20.1083C23.4619 20.1083 23.2817 20.0337 23.1489 19.9009C23.016 19.768 22.9414 19.5878 22.9414 19.4C22.9414 19.2121 23.016 19.032 23.1489 18.8991C23.2817 18.7663 23.4619 18.6917 23.6497 18.6917C23.8376 18.6917 24.0178 18.7663 24.1506 18.8991C24.2834 19.032 24.3581 19.2121 24.3581 19.4Z" fill="white"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M17.9434 13.2021H20.1477C21.4497 13.2021 22.481 13.2021 23.2878 13.3105C24.1179 13.4224 24.7902 13.6575 25.3207 14.1874C25.9752 14.8426 26.1842 15.7195 26.2599 16.8578C26.6687 17.037 26.9775 17.4174 27.0108 17.899C27.0143 17.9423 27.0143 17.9883 27.0143 18.0308V20.7692C27.0143 20.8117 27.0143 20.8578 27.0115 20.9003C26.9775 21.3819 26.6687 21.763 26.2599 21.9429C26.1842 23.0805 25.9752 23.9574 25.3207 24.6126C24.7902 25.1425 24.1179 25.3776 23.2878 25.4895C22.4803 25.5979 21.4497 25.5979 20.1477 25.5979H17.9434C16.6415 25.5979 15.6102 25.5979 14.8034 25.4895C13.9732 25.3776 13.301 25.1425 12.7704 24.6126C12.2406 24.0821 12.0054 23.4099 11.8935 22.5797C11.7852 21.7722 11.7852 20.7416 11.7852 19.4397V19.3603C11.7852 18.0584 11.7852 17.0271 11.8935 16.2203C12.0054 15.3901 12.2406 14.7179 12.7704 14.1874C13.301 13.6575 13.9732 13.4224 14.8034 13.3105C15.6109 13.2021 16.6415 13.2021 17.9434 13.2021ZM25.1854 22.0563H23.8127C22.2933 22.0563 20.9928 20.9031 20.9928 19.4C20.9928 17.8969 22.2933 16.7438 23.8119 16.7438H25.1847C25.1039 15.7939 24.9219 15.2917 24.5684 14.9389C24.2688 14.6393 23.858 14.4594 23.1454 14.3638C22.4179 14.266 21.4582 14.2646 20.1074 14.2646H17.9824C16.6316 14.2646 15.6725 14.266 14.9436 14.3638C14.2317 14.4594 13.8209 14.6393 13.5213 14.9389C13.2217 15.2385 13.0417 15.6494 12.9461 16.362C12.8484 17.0901 12.8469 18.0492 12.8469 19.4C12.8469 20.7508 12.8484 21.7106 12.9461 22.4388C13.0417 23.1506 13.2217 23.5615 13.5213 23.8611C13.8209 24.1607 14.2317 24.3406 14.9443 24.4363C15.6725 24.534 16.6316 24.5354 17.9824 24.5354H20.1074C21.4582 24.5354 22.4179 24.534 23.1461 24.4363C23.858 24.3406 24.2688 24.1607 24.5684 23.8611C24.9219 23.5083 25.1047 23.0068 25.1854 22.0563ZM14.6185 16.5667C14.6185 16.4258 14.6745 16.2906 14.7741 16.191C14.8737 16.0914 15.0088 16.0354 15.1497 16.0354H17.9831C18.124 16.0354 18.2591 16.0914 18.3587 16.191C18.4584 16.2906 18.5143 16.4258 18.5143 16.5667C18.5143 16.7076 18.4584 16.8427 18.3587 16.9423C18.2591 17.0419 18.124 17.0979 17.9831 17.0979H15.1497C15.0088 17.0979 14.8737 17.0419 14.7741 16.9423C14.6745 16.8427 14.6185 16.7076 14.6185 16.5667ZM25.7209 17.8063H23.8127C22.804 17.8063 22.0553 18.5564 22.0553 19.4C22.0553 20.2436 22.804 20.9938 23.8119 20.9938H25.7372C25.8831 20.9845 25.9462 20.8861 25.9511 20.8266V17.9734C25.9462 17.9139 25.8831 17.8155 25.7372 17.807L25.7209 17.8063Z" fill="white"/>
</g>
<defs>
<filter id="filter0_di_1080_13873" x="0.00039053" y="-6.19888e-06" width="38.8" height="38.8" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
<feFlood flood-opacity="0" result="BackgroundImageFix"/>
<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
<feOffset/>
<feGaussianBlur stdDeviation="2.7"/>
<feComposite in2="hardAlpha" operator="out"/>
<feColorMatrix type="matrix" values="0 0 0 0 0.72549 0 0 0 0 0.678431 0 0 0 0 1 0 0 0 0.7 0"/>
<feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_1080_13873"/>
<feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_1080_13873" result="shape"/>
<feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"/>
<feOffset dy="4"/>
<feGaussianBlur stdDeviation="3.9"/>
<feComposite in2="hardAlpha" operator="arithmetic" k2="-1" k3="1"/>
<feColorMatrix type="matrix" values="0 0 0 0 1 0 0 0 0 1 0 0 0 0 1 0 0 0 0.55 0"/>
<feBlend mode="normal" in2="shape" result="effect2_innerShadow_1080_13873"/>
</filter>
</defs>
                </svg>
                   </div>
                </Link>
                <UserDropdown/>
              </div>

              {/* Mobile Menu Button - Right side, always visible on mobile */}
              <button
                onClick={onLiveChatToggle}
                className="lg:hidden p-2 text-white -mr-2 relative"
              >
                <Iconify icon="solar:chat-round-dots-linear" size={24} />
                <span className="absolute top-1.5 right-1.5 w-2 h-2 bg-green-500 rounded-full"></span>
              </button>
            </div>
          </div>
        </div>
      </nav>
    )
  }

  return null
}

export default Navbar