'use client'

import { useEffect, useState } from 'react'
import { usePathname } from 'next/navigation'
import PageLoader from '../ui/PageLoader'

export default function NavigationLoader() {
  const pathname = usePathname()
  const [mounted, setMounted] = useState(false)
  const [isClosing, setIsClosing] = useState(false)

  useEffect(() => {
    // Sayfa değişimi başladığında
    setMounted(true)
    setIsClosing(false)
    
    // 1.8 saniye sonra kapanma animasyonunu başlat
    const hideTimer = setTimeout(() => {
      setIsClosing(true)
    }, 1800)

    // Kapanma animasyonu bittikten sonra unmount et (700ms animasyon + buffer)
    const unmountTimer = setTimeout(() => {
      setMounted(false)
    }, 2600)

    return () => {
      clearTimeout(hideTimer)
      clearTimeout(unmountTimer)
    }
  }, [pathname])

  if (!mounted) return null

  return <PageLoader isClosing={isClosing} />
}
