'use client'

import { motion } from 'framer-motion'
import { Modal } from '@/components/ui'
import Image from 'next/image'

interface MobileAppModalProps {
  isOpen: boolean
  onClose: () => void
}

export function MobileAppModal({ isOpen, onClose }: MobileAppModalProps) {
  const storeLinks = [
    {
      name: 'App Store',
      image: '/assets/images/store_png/appstore.png',
      url: 'https://apps.apple.com/app/kiqro'
    },
    {
      name: 'Google Play',
      image: '/assets/images/store_png/playstore.png',
      url: 'https://play.google.com/store/apps/details?id=com.kiqro'
    },
    {
      name: 'AppGallery',
      image: '/assets/images/store_png/appgallery.png',
      url: 'https://appgallery.huawei.com/app/kiqro'
    }
  ]

  return (
    <Modal isOpen={isOpen} onClose={onClose} size="md">
      <motion.div 
        className="flex flex-col items-center text-center space-y-6 p-4"
        initial={{ opacity: 0, y: 20 }}
        animate={{ opacity: 1, y: 0 }}
        transition={{ duration: 0.3 }}
      >
        {/* Başlık */}
        <motion.h2 
          className="text-xl md:text-2xl font-bold text-white"
          initial={{ opacity: 0, y: -10 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ delay: 0.1, duration: 0.3 }}
        >
          Mobil Uygulamamızı İndirin
        </motion.h2>

        {/* Açıklama */}
        <motion.p 
          className="text-sm md:text-base text-white/70"
          initial={{ opacity: 0 }}
          animate={{ opacity: 1 }}
          transition={{ delay: 0.2, duration: 0.3 }}
        >
          Bu görevi yapabilmek için mobil uygulamamızı indirmeniz gerekmektedir.
        </motion.p>

        {/* App Resmi */}
        <motion.div 
          className="relative w-full max-w-[500px] aspect-square"
          initial={{ opacity: 0, scale: 0.8 }}
          animate={{ opacity: 1, scale: 1 }}
          transition={{ delay: 0.3, duration: 0.4, type: "spring" as const, stiffness: 200 }}
        >
          <Image
            src="/assets/images/app.png"
            alt="Kiqro Mobile App"
            fill
            className="object-contain"
            quality={600}
            unoptimized
          />
        </motion.div>

        {/* Store Butonları */}
        <motion.div 
          className="w-full space-y-4"
          initial={{ opacity: 0, y: 20 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ delay: 0.4, duration: 0.3 }}
        >
          {/* Üst 2 buton */}
          <div className="grid grid-cols-2 gap-3">
            {storeLinks.slice(0, 2).map((store, index) => (
              <motion.a
                key={store.name}
                href={store.url}
                target="_blank"
                rel="noopener noreferrer"
                className="relative w-auto h-12 md:h-14 hover:scale-105 transition-transform duration-200"
                initial={{ opacity: 0, y: 20 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ delay: 0.5 + index * 0.1, duration: 0.3 }}
                whileHover={{ scale: 1.05 }}
                whileTap={{ scale: 0.95 }}
              >
                <Image
                  src={store.image}
                  alt={store.name}
                  fill
                  className="object-contain"
                  quality={100}
                  unoptimized
                />
              </motion.a>
            ))}
          </div>

          {/* Alt 1 buton - ortalanmış */}
          <div className="flex justify-center">
            <motion.a
              href={storeLinks[2].url}
              target="_blank"
              rel="noopener noreferrer"
              className="relative w-auto h-12 md:h-14 min-w-[50%] hover:scale-105 transition-transform duration-200"
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ delay: 0.7, duration: 0.3 }}
              whileHover={{ scale: 1.05 }}
              whileTap={{ scale: 0.95 }}
            >
              <Image
                src={storeLinks[2].image}
                alt={storeLinks[2].name}
                fill
                className="object-contain"
                quality={100}
                unoptimized
              />
            </motion.a>
          </div>
        </motion.div>

        {/* Alt Bilgi */}
        <motion.p 
          className="text-xs text-white/50 mt-4"
          initial={{ opacity: 0 }}
          animate={{ opacity: 1 }}
          transition={{ delay: 0.8, duration: 0.3 }}
        >
          Uygulamamızı indirerek daha fazla görev ve ödüle erişebilirsiniz!
        </motion.p>
      </motion.div>
    </Modal>
  )
}
