'use client'

import React from 'react'
import { cn } from '@/lib/utils'

import { iconData, type IconName } from '@/lib/icons'

export interface IconProps {
  /** İkon adı - Iconify formatında */
  name: IconName
  /** İkon boyutu - px cinsinden veya Tailwind size class */
  size?: number | 'xs' | 'sm' | 'md' | 'lg' | 'xl' | '2xl'
  /** İkon rengi - Tailwind color class */
  color?: string
  /** Ek CSS sınıfları */
  className?: string
  /** İkon tıklanabilir mi */
  clickable?: boolean
  /** Tıklama olayı */
  onClick?: () => void
}



// Boyut sınıfları
const sizeClasses = {
  xs: 'w-3 h-3',
  sm: 'w-4 h-4', 
  md: 'w-5 h-5',
  lg: 'w-6 h-6', 
  xl: 'w-8 h-8',
  '2xl': 'w-10 h-10'
}

const Icon: React.FC<IconProps> = ({ 
  name, 
  size = 'md', 
  color = 'currentColor', 
  className,
  clickable = false,
  onClick 
}) => {
  // Boyut belirleme
  const sizeClass = typeof size === 'number' 
    ? `w-[${size}px] h-[${size}px]` 
    : sizeClasses[size]

  // SVG içeriğini alma
  const svgContent = iconData[name]
  
  if (!svgContent) {
    console.warn(`Icon "${name}" not found`)
    return null
  }

  return (
    <span
      className={cn(
        'inline-flex items-center justify-center',
        sizeClass,
        color.startsWith('text-') ? color : `text-[${color}]`,
        clickable && 'cursor-pointer hover:opacity-80 transition-opacity',
        className
      )}
      onClick={clickable ? onClick : undefined}
      dangerouslySetInnerHTML={{ __html: svgContent }}
    />
  )
}

export { Icon }
export default Icon