'use client'

import Image from 'next/image'
import React, { useEffect, useState } from 'react'

interface PageLoaderProps {
  isClosing?: boolean
}

export default function PageLoader({ isClosing = false }: PageLoaderProps) {
  const [isAnimating, setIsAnimating] = useState(false)

  useEffect(() => {
    // Açılış animasyonu için küçük bir gecikme
    const timer = setTimeout(() => {
      setIsAnimating(true)
    }, 50)

    return () => clearTimeout(timer)
  }, [])

  return (
    <div className="fixed inset-0 z-50 flex items-center justify-center bg-base-1">
      <div 
        className={`flex flex-col items-center gap-6 transition-all duration-700 ease-out ${
          isClosing 
            ? 'translate-y-20 opacity-0' 
            : isAnimating 
              ? 'translate-y-0 opacity-100' 
              : 'translate-y-20 opacity-0'
        }`}
      >
        {/* Logo veya Ana Animasyon */}
        <div className="relative"> 
          {/* İç Nokta */}
          <div className="absolute inset-0 flex items-center justify-center">
            <div className="w-3 h-3 bg-primary rounded-full animate-pulse"></div>
          </div>
        </div>
        
        {/* Yükleniyor Metni */}
        <div className="flex flex-col items-center gap-4">
            <Image
            src="/assets/logo.png"        
            alt="Kiqro Logo"
            width={100}
            height={100}
            />
          <div className="flex gap-1">
            <div className="w-2 h-2 bg-primary rounded-full animate-bounce" style={{ animationDelay: '0ms' }}></div>
            <div className="w-2 h-2 bg-primary rounded-full animate-bounce" style={{ animationDelay: '150ms' }}></div>
            <div className="w-2 h-2 bg-primary rounded-full animate-bounce" style={{ animationDelay: '300ms' }}></div>
          </div>
            <h3 className="text-white font-normal md:text-lg  text-sm">Yükleniyor</h3>
        </div>
      </div>
    </div>
  )
}
