/**
 * Leaderboard Data
 * Separation of Concerns: Data layer
 */

export interface LeaderboardUser {
  rank: number
  name: string
  avatar: string
}

export interface LeaderboardReward {
  rank: string
  amount: string
}

// Günlük ödül tutarları (1-25 sırası)
export const dailyRewards = [
  '30₺',      // 1
  '25₺',      // 2
  '22.5₺',    // 3
  '21₺',      // 4
  '20₺',      // 5
  '19.5₺',    // 6
  '19.25₺',   // 7
  '19.15₺',   // 8
  '19.10₺',   // 9
  '19.09₺',   // 10
  '18.84₺',   // 11
  '18.74₺',   // 12
  '18.69₺',   // 13
  '18.68₺',   // 14
  '18.43₺',   // 15
  '18.33₺',   // 16
  '18.28₺',   // 17
  '18.27₺',   // 18
  '18.02₺',   // 19
  '17.92₺',   // 20
  '17.87₺',   // 21
  '17.86₺',   // 22
  '17.61₺',   // 23
  '17.51₺',   // 24
  '17.46₺',   // 25
];

// Aylık ödül tutarları (1-25 sırası)
export const monthlyRewards = [
  '1500₺',    // 1
  '1100₺',    // 2
  '850₺',     // 3
  '650₺',     // 4
  '550₺',     // 5
  '500₺',     // 6
  '475₺',     // 7
  '462.5₺',   // 8
  '452.5₺',   // 9
  '447.5₺',   // 10
  '422.5₺',   // 11
  '410₺',     // 12
  '400₺',     // 13
  '395₺',     // 14
  '370₺',     // 15
  '357.5₺',   // 16
  '347.5₺',   // 17
  '342.5₺',   // 18
  '317.5₺',   // 19
  '305₺',     // 20
  '295₺',     // 21
  '290₺',     // 22
  '265₺',     // 23
  '252.5₺',   // 24
  '242.5₺',   // 25
];

// Kullanıcı verileri (Günlük ve Aylık için ortak)
export const leaderboardUsers: LeaderboardUser[] = [
  { rank: 1, name: "Bryan Wolf", avatar: "/assets/images/pp1.png" },
  { rank: 2, name: "Meghan Jes...", avatar: "/assets/images/pp1.png" },
  { rank: 3, name: "Alex Turner", avatar: "/assets/images/pp1.png" },
  { rank: 4, name: "Marsha Fisher", avatar: "/assets/images/pp1.png" },
  { rank: 5, name: "Juanita Cormier", avatar: "/assets/images/pp1.png" },
  { rank: 6, name: "You", avatar: "/assets/images/pp1.png" },
  { rank: 7, name: "Tamara Schmidt", avatar: "/assets/images/pp1.png" },
  { rank: 8, name: "Ricardo Veum", avatar: "/assets/images/pp1.png" },
  { rank: 9, name: "Gary Sanford", avatar: "/assets/images/pp1.png" },
  { rank: 10, name: "Becky Bartell", avatar: "/assets/images/pp1.png" },
  { rank: 11, name: "Sarah Johnson", avatar: "/assets/images/pp2.png" },
  { rank: 12, name: "Mike Anderson", avatar: "/assets/images/pp1.png" },
  { rank: 13, name: "Emily Davis", avatar: "/assets/images/pp2.png" },
  { rank: 14, name: "James Wilson", avatar: "/assets/images/pp1.png" },
  { rank: 15, name: "Lisa Brown", avatar: "/assets/images/pp2.png" },
  { rank: 16, name: "David Miller", avatar: "/assets/images/pp1.png" },
  { rank: 17, name: "Emma Taylor", avatar: "/assets/images/pp2.png" },
  { rank: 18, name: "Chris Martinez", avatar: "/assets/images/pp1.png" },
  { rank: 19, name: "Anna Garcia", avatar: "/assets/images/pp2.png" },
  { rank: 20, name: "Tom Rodriguez", avatar: "/assets/images/pp1.png" },
  { rank: 21, name: "Sophie Lee", avatar: "/assets/images/pp2.png" },
  { rank: 22, name: "John Smith", avatar: "/assets/images/pp1.png" },
  { rank: 23, name: "Maria Lopez", avatar: "/assets/images/pp2.png" },
  { rank: 24, name: "Robert Chen", avatar: "/assets/images/pp1.png" },
  { rank: 25, name: "Jennifer White", avatar: "/assets/images/pp2.png" },
];

// Helper function - ödül tutarını al
export const getRewardAmount = (rank: number, timeFilter: 'daily' | 'monthly'): string => {
  const rewards = timeFilter === 'daily' ? dailyRewards : monthlyRewards;
  return rewards[rank - 1] || '0₺';
};

// Helper function - leaderboard verilerini al
export const getLeaderboardData = (): LeaderboardUser[] => {
  return leaderboardUsers;
};

// Legacy data - backward compatibility
export const leaderboardRewards: LeaderboardReward[] = [
  { rank: '1.', amount: '30₺' },
  { rank: '2.', amount: '25₺' },
  { rank: '3.', amount: '22.5₺' },
  { rank: '4-10', amount: '21₺ - 19.09₺' },
  { rank: '11-25', amount: '18.84₺ - 17.46₺' }
]
