/**
 * Live Chat Data
 * Canlı destek mesajlaşma verileri
 * MobileLiveChat ve LiveSupportWidget için ortak veri kaynağı
 */

export interface LiveChatMessage {
  id: string
  sender: string
  avatar?: string
  message: string
  time: string
  isOnline?: boolean
  isUser?: boolean
}

/**
 * Canlı destek mesajları
 * Hem mobil hem web için ortak mesaj listesi
 */
export const liveChatMessages: LiveChatMessage[] = [
  {
    id: '1',
    sender: 'Emma Collins',
    avatar: '/assets/images/pp1.png',
    message: 'Spotify\'da 3dk Manifest şarkısını dinle kazan etkinliği başlamış 🎵 Kaçırmayın, ödüller çok iyi!',
    time: '12:21',
    isOnline: true,
    isUser: false
  },
  {
    id: '2',
    sender: 'Sophia Reed',
    avatar: '/assets/images/pp1.png',
    message: 'Arkadaşlar Instagram\'da yeni takip kazan kampanyası açıldı 📱 Ödülü efsane, hemen deneyin!',
    time: '12:24',
    isOnline: true,
    isUser: false
  },
  {
    id: '3',
    sender: 'Lily Turner',
    avatar: '/assets/images/pp1.png',
    message: 'X\'te #LikeVeRetweet kampanyası var 👍 Katılanlara sürpriz hediye gönderiyorlar, şansı kaçırmayın.',
    time: '12:29',
    isOnline: false,
    isUser: false
  },
  {
    id: '4',
    sender: 'Emma Collins',
    avatar: '/assets/images/pp1.png',
    message: 'TikTok\'ta #Challenge etkinliği var 🎬 Katılanlara hediye kutusu geliyor, eğlenceli de görünüyor hemen yapın!',
    time: '12:34',
    isOnline: true,
    isUser: false
  },
  {
    id: '5',
    sender: 'Ethan Brooks',
    avatar: '/assets/images/pp1.png',
    message: 'YouTube\'da yorum yap kazan etkinliği başlamış 💬 Abone ol + yorum yap, hediye çekilişine giriyorsun!',
    time: '12:34',
    isOnline: false,
    isUser: false
  }
]

/**
 * Canlı destek mesajlarını getirir
 * @returns Mesaj listesi
 */
export const getLiveChatMessages = (): LiveChatMessage[] => {
  return liveChatMessages
}

/**
 * Yeni mesaj ID'si oluşturur
 * @returns Yeni mesaj ID'si
 */
export const generateMessageId = (): string => {
  return `msg_${Date.now()}_${Math.random().toString(36).substr(2, 9)}`
}

/**
 * Mesaj zamanı formatlar
 * @returns Formatlanmış zaman (HH:MM)
 */
export const getFormattedTime = (): string => {
  const now = new Date()
  const hours = now.getHours().toString().padStart(2, '0')
  const minutes = now.getMinutes().toString().padStart(2, '0')
  return `${hours}:${minutes}`
}
