/**
 * Live Payments Data
 * Canlı para çekme işlemleri verileri
 */

import type { IconName } from '@/lib/icons'

export interface LivePayment {
  id: string
  name: string
  avatar: string
  timeAgo: string
  amount: string
  paymentMethod: string
  paymentIcon: IconName
}

/**
 * Kullanılabilir isimler listesi
 */
const names = [
  'Ahmet Y.',
  'Mehmet K.',
  'Ayşe D.',
  'Fatma S.',
  'Ali R.',
  'Zeynep A.',
  'Mustafa Ö.',
  'Elif T.',
  'Emre B.',
  'Selin M.',
  'Can G.',
  'Deniz P.',
  'Burak C.',
  'Merve L.',
  'Kerem N.',
  'Ece H.',
  'Onur V.',
  'Ceren Y.',
  'Berk Z.',
  'Nazlı K.'
]

/**
 * Kullanılabilir avatar'lar
 */
const avatars = [
  '/assets/images/pp1.png',
  '/assets/images/pp2.png'
]

/**
 * Ödeme metodları
 */
const paymentMethods = [
  { name: 'Papara', icon: 'papara' as IconName },
  { name: 'Banka', icon: 'mdi:bank-outline' as IconName }
]

/**
 * Başlangıç ödeme kayıtları
 */
export const initialPayments: LivePayment[] = [
  {
    id: '1',
    name: 'Ahmet Y.',
    avatar: '/assets/images/pp1.png',
    timeAgo: '15 saniye önce',
    amount: '1.250₺',
    paymentMethod: 'Papara',
    paymentIcon: 'papara'
  },
  {
    id: '2',
    name: 'Zeynep A.',
    avatar: '/assets/images/pp2.png',
    timeAgo: '42 saniye önce',
    amount: '3.750₺',
    paymentMethod: 'Banka',
    paymentIcon: 'mdi:bank-outline'
  },
  {
    id: '3',
    name: 'Mehmet K.',
    avatar: '/assets/images/pp1.png',
    timeAgo: '1 dakika önce',
    amount: '850₺',
    paymentMethod: 'Papara',
    paymentIcon: 'papara'
  },
  {
    id: '4',
    name: 'Elif T.',
    avatar: '/assets/images/pp2.png',
    timeAgo: '2 dakika önce',
    amount: '2.100₺',
    paymentMethod: 'Banka',
    paymentIcon: 'mdi:bank-outline'
  }
]

/**
 * Rastgele miktar üretir (500₺ - 5000₺ arası)
 */
const getRandomAmount = (): string => {
  const amount = Math.floor(Math.random() * 4500) + 500
  return `${amount.toLocaleString('tr-TR')}₺`
}

/**
 * Rastgele zaman önce metni üretir
 */
const getRandomTimeAgo = (): string => {
  const seconds = Math.floor(Math.random() * 120) + 5
  
  if (seconds < 60) {
    return `${seconds} saniye önce`
  } else {
    const minutes = Math.floor(seconds / 60)
    return `${minutes} dakika önce`
  }
}

/**
 * Rastgele isim seçer
 */
const getRandomName = (): string => {
  return names[Math.floor(Math.random() * names.length)]
}

/**
 * Rastgele avatar seçer
 */
const getRandomAvatar = (): string => {
  return avatars[Math.floor(Math.random() * avatars.length)]
}

/**
 * Rastgele ödeme metodu seçer
 */
const getRandomPaymentMethod = () => {
  return paymentMethods[Math.floor(Math.random() * paymentMethods.length)]
}

/**
 * Yeni bir canlı ödeme kaydı oluşturur
 */
export const generateLivePayment = (): LivePayment => {
  const paymentMethod = getRandomPaymentMethod()
  
  return {
    id: `payment_${Date.now()}_${Math.random().toString(36).substr(2, 9)}`,
    name: getRandomName(),
    avatar: getRandomAvatar(),
    timeAgo: getRandomTimeAgo(),
    amount: getRandomAmount(),
    paymentMethod: paymentMethod.name,
    paymentIcon: paymentMethod.icon
  }
}

/**
 * Başlangıç ödemelerini getirir
 */
export const getInitialPayments = (): LivePayment[] => {
  return initialPayments
}

/**
 * Son 24 saatte kaç kişinin para çektiğini gösterir (simüle edilmiş)
 */
export const getTotalWithdrawalsToday = (): number => {
  return Math.floor(Math.random() * 500) + 200
}
