// Solar Icon Set - SVG verileri
export const solarIcons = {
'solar:money-bag-bold': `
    <svg width="27" height="27" viewBox="0 0 27 27" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path fill-rule="evenodd" clip-rule="evenodd" d="M13.5585 1.40625H13.4415C12.4301 1.40625 11.5875 1.40625 10.9192 1.49625C10.2127 1.59075 9.57487 1.8 9.063 2.31187C8.55 2.82487 8.34075 3.46275 8.24625 4.16812C8.18212 4.6485 8.163 5.79487 8.1585 6.77812C5.88375 6.8535 4.51687 7.119 3.5685 8.0685C2.25 9.38587 2.25 11.5076 2.25 15.75C2.25 19.9924 2.25 22.1141 3.5685 23.4315C4.887 24.7489 7.00762 24.75 11.25 24.75H15.75C19.9924 24.75 22.1141 24.75 23.4315 23.4315C24.7489 22.113 24.75 19.9924 24.75 15.75C24.75 11.5076 24.75 9.38587 23.4315 8.0685C22.4831 7.119 21.1162 6.8535 18.8415 6.77925C18.837 5.79487 18.819 4.6485 18.7537 4.16925C18.6592 3.46275 18.45 2.82487 17.937 2.313C17.4251 1.8 16.7872 1.59075 16.0807 1.49625C15.4125 1.40625 14.5687 1.40625 13.5585 1.40625ZM17.154 6.75225C17.1484 5.79937 17.1326 4.7745 17.082 4.39312C17.0111 3.8745 16.8907 3.65175 16.7445 3.5055C16.5982 3.35925 16.3755 3.23887 15.8557 3.168C15.3135 3.096 14.5845 3.09375 13.5 3.09375C12.4155 3.09375 11.6865 3.096 11.1431 3.16912C10.6245 3.23887 10.4017 3.35925 10.2555 3.50662C10.1092 3.654 9.98887 3.8745 9.918 4.39312C9.86737 4.77562 9.8505 5.79937 9.846 6.75225C10.287 6.75 10.755 6.74925 11.25 6.75H15.75C16.2465 6.75 16.7145 6.75075 17.154 6.75225ZM13.5 10.4062C13.7238 10.4062 13.9384 10.4951 14.0966 10.6534C14.2549 10.8116 14.3437 11.0262 14.3437 11.25V11.2612C15.5689 11.5695 16.5937 12.5359 16.5937 13.8746C16.5937 14.0984 16.5049 14.313 16.3466 14.4712C16.1884 14.6295 15.9738 14.7184 15.75 14.7184C15.5262 14.7184 15.3116 14.6295 15.1534 14.4712C14.9951 14.313 14.9062 14.0984 14.9062 13.8746C14.9062 13.4426 14.427 12.8441 13.5 12.8441C12.573 12.8441 12.0937 13.4426 12.0937 13.8746C12.0937 14.3066 12.573 14.9062 13.5 14.9062C15.0581 14.9062 16.5937 15.9862 16.5937 17.6254C16.5937 18.9641 15.5689 19.9294 14.3437 20.2387V20.25C14.3437 20.4738 14.2549 20.6884 14.0966 20.8466C13.9384 21.0049 13.7238 21.0937 13.5 21.0937C13.2762 21.0937 13.0616 21.0049 12.9034 20.8466C12.7451 20.6884 12.6562 20.4738 12.6562 20.25V20.2387C11.4311 19.9305 10.4062 18.9641 10.4062 17.6254C10.4062 17.4016 10.4951 17.187 10.6534 17.0288C10.8116 16.8705 11.0262 16.7816 11.25 16.7816C11.4738 16.7816 11.6884 16.8705 11.8466 17.0288C12.0049 17.187 12.0937 17.4016 12.0937 17.6254C12.0937 18.0574 12.573 18.6559 13.5 18.6559C14.427 18.6559 14.9062 18.0574 14.9062 17.6254C14.9062 17.1934 14.427 16.5937 13.5 16.5937C11.9419 16.5937 10.4062 15.5137 10.4062 13.8746C10.4062 12.5359 11.4311 11.5695 12.6562 11.2612V11.25C12.6562 11.0262 12.7451 10.8116 12.9034 10.6534C13.0616 10.4951 13.2762 10.4062 13.5 10.4062Z" fill="url(#paint0_linear_968_20624)"/>
    <defs>
    <linearGradient id="paint0_linear_968_20624" x1="13.5" y1="9.43066" x2="13.5" y2="27.668" gradientUnits="userSpaceOnUse">
    <stop stop-color="#B5A9FF"/>
    <stop offset="1" stop-color="#36246A"/>
    </linearGradient>
    </defs>
    </svg>
  `,
  'fa6-solid:list' : `<svg width="17" height="17" viewBox="0 0 17 17" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M1.32812 1.59375C0.886523 1.59375 0.53125 1.94902 0.53125 2.39062V3.98438C0.53125 4.42598 0.886523 4.78125 1.32812 4.78125H2.92188C3.36348 4.78125 3.71875 4.42598 3.71875 3.98438V2.39062C3.71875 1.94902 3.36348 1.59375 2.92188 1.59375H1.32812ZM6.375 2.125C5.7873 2.125 5.3125 2.5998 5.3125 3.1875C5.3125 3.7752 5.7873 4.25 6.375 4.25H15.9375C16.5252 4.25 17 3.7752 17 3.1875C17 2.5998 16.5252 2.125 15.9375 2.125H6.375ZM6.375 7.4375C5.7873 7.4375 5.3125 7.9123 5.3125 8.5C5.3125 9.0877 5.7873 9.5625 6.375 9.5625H15.9375C16.5252 9.5625 17 9.0877 17 8.5C17 7.9123 16.5252 7.4375 15.9375 7.4375H6.375ZM6.375 12.75C5.7873 12.75 5.3125 13.2248 5.3125 13.8125C5.3125 14.4002 5.7873 14.875 6.375 14.875H15.9375C16.5252 14.875 17 14.4002 17 13.8125C17 13.2248 16.5252 12.75 15.9375 12.75H6.375ZM0.53125 7.70312V9.29688C0.53125 9.73848 0.886523 10.0938 1.32812 10.0938H2.92188C3.36348 10.0938 3.71875 9.73848 3.71875 9.29688V7.70312C3.71875 7.26152 3.36348 6.90625 2.92188 6.90625H1.32812C0.886523 6.90625 0.53125 7.26152 0.53125 7.70312ZM1.32812 12.2188C0.886523 12.2188 0.53125 12.574 0.53125 13.0156V14.6094C0.53125 15.051 0.886523 15.4062 1.32812 15.4062H2.92188C3.36348 15.4062 3.71875 15.051 3.71875 14.6094V13.0156C3.71875 12.574 3.36348 12.2188 2.92188 12.2188H1.32812Z" fill="url(#paint0_linear_972_28488)"/>
<defs>
<linearGradient id="paint0_linear_972_28488" x1="8.5" y1="1.5" x2="12" y2="19" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`,
'task-1':`<svg width="22" height="32" viewBox="0 0 22 32" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.4038 1.28955L15.1389 6.95622L19.8077 3.17844L17.9402 12.6229H4.86752L3 3.17844L7.6688 6.95622L11.4038 1.28955Z" fill="url(#paint0_linear_972_28490)"/>
<path d="M14.9474 11.6289H6.71068C3.13291 11.6289 1 13.7862 1 17.4049V25.7359C1 29.3546 3.13291 31.5119 6.71068 31.5119H14.9474C18.5252 31.5119 20.6581 29.3546 20.6581 25.7359V17.4049C20.6581 13.7862 18.5252 11.6289 14.9474 11.6289ZM8.83376 24.4535L6.62222 26.6903C6.47479 26.8394 6.28804 26.909 6.10128 26.909C5.91453 26.909 5.71795 26.8394 5.58034 26.6903L4.84316 25.9447C4.54829 25.6564 4.54829 25.1792 4.84316 24.8909C5.12821 24.6026 5.59017 24.6026 5.88504 24.8909L6.10128 25.1096L7.79188 23.3997C8.07692 23.1114 8.53889 23.1114 8.83376 23.3997C9.11881 23.688 9.11881 24.1652 8.83376 24.4535ZM8.83376 17.4944L6.62222 19.7312C6.47479 19.8804 6.28804 19.95 6.10128 19.95C5.91453 19.95 5.71795 19.8804 5.58034 19.7312L4.84316 18.9856C4.54829 18.6973 4.54829 18.2201 4.84316 17.9318C5.12821 17.6435 5.59017 17.6435 5.88504 17.9318L6.10128 18.1505L7.79188 16.4406C8.07692 16.1523 8.53889 16.1523 8.83376 16.4406C9.11881 16.7289 9.11881 17.2061 8.83376 17.4944ZM16.294 26.1634H11.1338C10.7308 26.1634 10.3966 25.8254 10.3966 25.4178C10.3966 25.0102 10.7308 24.6722 11.1338 24.6722H16.294C16.7068 24.6722 17.0312 25.0102 17.0312 25.4178C17.0312 25.8254 16.7068 26.1634 16.294 26.1634ZM16.294 19.2043H11.1338C10.7308 19.2043 10.3966 18.8663 10.3966 18.4587C10.3966 18.0511 10.7308 17.7131 11.1338 17.7131H16.294C16.7068 17.7131 17.0312 18.0511 17.0312 18.4587C17.0312 18.8663 16.7068 19.2043 16.294 19.2043Z" fill="url(#paint1_linear_972_28490)"/>
<defs>
<linearGradient id="paint0_linear_972_28490" x1="11.4038" y1="5.18538" x2="11.4038" y2="14.0396" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
<linearGradient id="paint1_linear_972_28490" x1="10.8291" y1="18.4637" x2="10.8291" y2="33.9973" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`,
'task-2':`<svg width="23" height="35" viewBox="0 0 23 35" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15.9474 8H7.71068C4.13291 8 2 10.1573 2 13.776V22.107C2 25.7257 4.13291 27.883 7.71068 27.883H15.9474C19.5252 27.883 21.6581 25.7257 21.6581 22.107V13.776C21.6581 10.1573 19.5252 8 15.9474 8ZM9.83376 20.8246L7.62222 23.0614C7.47479 23.2105 7.28803 23.2801 7.10128 23.2801C6.91453 23.2801 6.71795 23.2105 6.58034 23.0614L5.84316 22.3158C5.54829 22.0275 5.54829 21.5503 5.84316 21.262C6.12821 20.9737 6.59017 20.9737 6.88504 21.262L7.10128 21.4807L8.79188 19.7708C9.07692 19.4825 9.53889 19.4825 9.83376 19.7708C10.1188 20.0591 10.1188 20.5363 9.83376 20.8246ZM9.83376 13.8655L7.62222 16.1023C7.47479 16.2515 7.28803 16.3211 7.10128 16.3211C6.91453 16.3211 6.71795 16.2515 6.58034 16.1023L5.84316 15.3567C5.54829 15.0684 5.54829 14.5912 5.84316 14.3029C6.12821 14.0146 6.59017 14.0146 6.88504 14.3029L7.10128 14.5216L8.79188 12.8117C9.07692 12.5234 9.53889 12.5234 9.83376 12.8117C10.1188 13.1 10.1188 13.5772 9.83376 13.8655ZM17.294 22.5345H12.1338C11.7308 22.5345 11.3966 22.1965 11.3966 21.7889C11.3966 21.3813 11.7308 21.0433 12.1338 21.0433H17.294C17.7068 21.0433 18.0312 21.3813 18.0312 21.7889C18.0312 22.1965 17.7068 22.5345 17.294 22.5345ZM17.294 15.5754H12.1338C11.7308 15.5754 11.3966 15.2374 11.3966 14.8298C11.3966 14.4222 11.7308 14.0842 12.1338 14.0842H17.294C17.7068 14.0842 18.0312 14.4222 18.0312 14.8298C18.0312 15.2374 17.7068 15.5754 17.294 15.5754Z" fill="url(#paint0_linear_972_28515)"/>
<defs>
<linearGradient id="paint0_linear_972_28515" x1="11.8291" y1="14.8348" x2="11.8291" y2="30.3684" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`,
'fluent:headphones-sound-wave-24-filled':`<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3.5 12C3.5 9.74566 4.39553 7.58365 5.98959 5.98959C7.58365 4.39553 9.74566 3.5 12 3.5C14.2543 3.5 16.4163 4.39553 18.0104 5.98959C19.6045 7.58365 20.5 9.74566 20.5 12V14H18.25C18.0511 14 17.8603 14.079 17.7197 14.2197C17.579 14.3603 17.5 14.5511 17.5 14.75V21.25C17.5 21.664 17.836 22 18.25 22H19C19.7956 22 20.5587 21.6839 21.1213 21.1213C21.6839 20.5587 22 19.7956 22 19V12C22 6.477 17.523 2 12 2C6.477 2 2 6.477 2 12V19C2 19.7956 2.31607 20.5587 2.87868 21.1213C3.44129 21.6839 4.20435 22 5 22H5.75C5.94891 22 6.13968 21.921 6.28033 21.7803C6.42098 21.6397 6.5 21.4489 6.5 21.25V14.75C6.5 14.5511 6.42098 14.3603 6.28033 14.2197C6.13968 14.079 5.94891 14 5.75 14H3.5V12ZM12.75 11.75C12.75 11.5511 12.671 11.3603 12.5303 11.2197C12.3897 11.079 12.1989 11 12 11C11.8011 11 11.6103 11.079 11.4697 11.2197C11.329 11.3603 11.25 11.5511 11.25 11.75V22.25C11.25 22.4489 11.329 22.6397 11.4697 22.7803C11.6103 22.921 11.8011 23 12 23C12.1989 23 12.3897 22.921 12.5303 22.7803C12.671 22.6397 12.75 22.4489 12.75 22.25V11.75ZM8.75 14C8.94891 14 9.13968 14.079 9.28033 14.2197C9.42098 14.3603 9.5 14.5511 9.5 14.75V19.25C9.5 19.4489 9.42098 19.6397 9.28033 19.7803C9.13968 19.921 8.94891 20 8.75 20C8.55109 20 8.36032 19.921 8.21967 19.7803C8.07902 19.6397 8 19.4489 8 19.25V14.75C8 14.5511 8.07902 14.3603 8.21967 14.2197C8.36032 14.079 8.55109 14 8.75 14ZM16 14.75C16 14.5511 15.921 14.3603 15.7803 14.2197C15.6397 14.079 15.4489 14 15.25 14C15.0511 14 14.8603 14.079 14.7197 14.2197C14.579 14.3603 14.5 14.5511 14.5 14.75V19.25C14.5 19.4489 14.579 19.6397 14.7197 19.7803C14.8603 19.921 15.0511 20 15.25 20C15.4489 20 15.6397 19.921 15.7803 19.7803C15.921 19.6397 16 19.4489 16 19.25V14.75Z" fill="url(#paint0_linear_972_28518)"/>
<defs>
<linearGradient id="paint0_linear_972_28518" x1="12" y1="2" x2="12" y2="29.5" gradientUnits="userSpaceOnUse">
<stop offset="0.25" stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`,
'heroicons:newspaper':`<svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12 8H13.5M12 11H13.5M6 14H13.5M6 17H13.5M16.5 8H19.875C20.496 8 21 8.504 21 9.125V18.5C21 19.0967 20.7629 19.669 20.341 20.091C19.919 20.5129 19.3467 20.75 18.75 20.75M16.5 8V18.5C16.5 19.0967 16.7371 19.669 17.159 20.091C17.581 20.5129 18.1533 20.75 18.75 20.75M16.5 8V5.375C16.5 4.754 15.996 4.25 15.375 4.25H4.125C3.504 4.25 3 4.754 3 5.375V18.5C3 19.0967 3.23705 19.669 3.65901 20.091C4.08097 20.5129 4.65326 20.75 5.25 20.75H18.75M6 8H9V11H6V8Z" stroke="url(#paint0_linear_972_28520)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<defs>
<linearGradient id="paint0_linear_972_28520" x1="12" y1="9.92188" x2="12" y2="22.8125" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`,
'tdesign:money-filled': `<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.5 16C13.5 16.3978 13.342 16.7794 13.0607 17.0607C12.7794 17.342 12.3978 17.5 12 17.5C11.6022 17.5 11.2206 17.342 10.9393 17.0607C10.658 16.7794 10.5 16.3978 10.5 16C10.5 15.6022 10.658 15.2206 10.9393 14.9393C11.2206 14.658 11.6022 14.5 12 14.5C12.3978 14.5 12.7794 14.658 13.0607 14.9393C13.342 15.2206 13.5 15.6022 13.5 16Z" fill="url(#paint0_linear_972_28523)"/>
<path d="M14.347 0.660156L17.527 5.11616L19.624 4.40116L21.538 10.0002H22.5V22.0002H1.5V10.0002H2.01V9.99016L2.658 9.99616L14.347 0.660156ZM9.397 10.0002H19.425L18.388 6.96716L16.866 7.45416L9.397 10.0002ZM7.839 8.41716L15.55 5.79016L13.946 3.54016L7.839 8.41716ZM5.5 12.0002H3.5V14.0002C4.03043 14.0002 4.53914 13.7894 4.91421 13.4144C5.28929 13.0393 5.5 12.5306 5.5 12.0002ZM15.5 16.0002C15.5 15.5405 15.4095 15.0854 15.2336 14.6608C15.0577 14.2361 14.7999 13.8503 14.4749 13.5253C14.1499 13.2003 13.764 12.9425 13.3394 12.7666C12.9148 12.5907 12.4596 12.5002 12 12.5002C11.5404 12.5002 11.0852 12.5907 10.6606 12.7666C10.236 12.9425 9.85013 13.2003 9.52513 13.5253C9.20012 13.8503 8.94231 14.2361 8.76642 14.6608C8.59053 15.0854 8.5 15.5405 8.5 16.0002C8.5 16.9284 8.86875 17.8187 9.52513 18.475C10.1815 19.1314 11.0717 19.5002 12 19.5002C12.9283 19.5002 13.8185 19.1314 14.4749 18.475C15.1313 17.8187 15.5 16.9284 15.5 16.0002ZM20.5 20.0002V18.0002C19.9696 18.0002 19.4609 18.2109 19.0858 18.5859C18.7107 18.961 18.5 19.4697 18.5 20.0002H20.5ZM18.5 12.0002C18.5 12.5306 18.7107 13.0393 19.0858 13.4144C19.4609 13.7894 19.9696 14.0002 20.5 14.0002V12.0002H18.5ZM3.5 20.0002H5.5C5.5 19.4697 5.28929 18.961 4.91421 18.5859C4.53914 18.2109 4.03043 18.0002 3.5 18.0002V20.0002Z" fill="url(#paint1_linear_972_28523)"/>
<defs>
<linearGradient id="paint0_linear_972_28523" x1="12" y1="15.5313" x2="12" y2="17.875" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
<linearGradient id="paint1_linear_972_28523" x1="12" y1="7.99578" x2="12" y2="24.6677" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`,
'material-symbols:leaderboard-rounded':`<svg width="22" height="21" viewBox="0 0 22 21" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_972_28527)">
<path d="M2.95 20C2.68083 20 2.45537 19.9147 2.2736 19.744C2.09183 19.5733 2.00063 19.3624 2 19.1111V10.2222C2 9.97037 2.0912 9.75941 2.2736 9.58933C2.456 9.41926 2.68147 9.33392 2.95 9.33333H6.275C6.54417 9.33333 6.76995 9.41867 6.95235 9.58933C7.13475 9.76 7.22563 9.97096 7.225 10.2222V19.1111C7.225 19.363 7.1338 19.5742 6.9514 19.7449C6.769 19.9156 6.54353 20.0006 6.275 20H2.95ZM9.8375 20C9.56833 20 9.34287 19.9147 9.1611 19.744C8.97933 19.5733 8.88813 19.3624 8.8875 19.1111V4.88889C8.8875 4.63704 8.9787 4.42607 9.1611 4.256C9.3435 4.08593 9.56897 4.00059 9.8375 4H13.1625C13.4317 4 13.6574 4.08533 13.8398 4.256C14.0222 4.42667 14.1131 4.63763 14.1125 4.88889V19.1111C14.1125 19.363 14.0213 19.5742 13.8389 19.7449C13.6565 19.9156 13.431 20.0006 13.1625 20H9.8375ZM16.725 20C16.4558 20 16.2304 19.9147 16.0486 19.744C15.8668 19.5733 15.7756 19.3624 15.775 19.1111V12C15.775 11.7481 15.8662 11.5372 16.0486 11.3671C16.231 11.197 16.4565 11.1117 16.725 11.1111H20.05C20.3192 11.1111 20.5449 11.1964 20.7273 11.3671C20.9097 11.5378 21.0006 11.7487 21 12V19.1111C21 19.363 20.9088 19.5742 20.7264 19.7449C20.544 19.9156 20.3185 20.0006 20.05 20H16.725Z" fill="url(#paint0_linear_972_28527)"/>
</g>
<defs>
<linearGradient id="paint0_linear_972_28527" x1="11.5" y1="9.5" x2="11.5" y2="22" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
<clipPath id="clip0_972_28527">
<rect width="22" height="21" fill="white"/>
</clipPath>
</defs>
</svg>
`,
'mdi:user-plus': `<svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 14.5C12.33 14.5 7 15.83 7 18.5V20.5H23V18.5C23 15.83 17.67 14.5 15 14.5ZM6 10.5V7.5H4V10.5H1V12.5H4V15.5H6V12.5H9V10.5M15 12.5C16.0609 12.5 17.0783 12.0786 17.8284 11.3284C18.5786 10.5783 19 9.56087 19 8.5C19 7.43913 18.5786 6.42172 17.8284 5.67157C17.0783 4.92143 16.0609 4.5 15 4.5C13.9391 4.5 12.9217 4.92143 12.1716 5.67157C11.4214 6.42172 11 7.43913 11 8.5C11 9.56087 11.4214 10.5783 12.1716 11.3284C12.9217 12.0786 13.9391 12.5 15 12.5Z" fill="url(#paint0_linear_972_28530)"/>
<defs>
<linearGradient id="paint0_linear_972_28530" x1="12" y1="10" x2="12" y2="22.5" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`,
'flowbite:gift-box-outline':`<svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 21.5V12.5M13 8.5H7.5C6.83696 8.5 6.20107 8.23661 5.73223 7.76777C5.26339 7.29893 5 6.66304 5 6C5 5.33696 5.26339 4.70107 5.73223 4.23223C6.20107 3.76339 6.83696 3.5 7.5 3.5C9 3.5 10.375 4.75 11.375 6M14 21.5V12.5M5 12.5H19V20.5C19 20.7652 18.8946 21.0196 18.7071 21.2071C18.5196 21.3946 18.2652 21.5 18 21.5H6C5.73478 21.5 5.48043 21.3946 5.29289 21.2071C5.10536 21.0196 5 20.7652 5 20.5V12.5ZM4 8.5H20C20.2652 8.5 20.5196 8.60536 20.7071 8.79289C20.8946 8.98043 21 9.23478 21 9.5V12.5H3V9.5C3 9.23478 3.10536 8.98043 3.29289 8.79289C3.48043 8.60536 3.73478 8.5 4 8.5ZM16.155 3.5C13.155 3.5 10.655 8.5 10.655 8.5H16.155C16.818 8.5 17.4539 8.23661 17.9228 7.76777C18.3916 7.29893 18.655 6.66304 18.655 6C18.655 5.33696 18.3916 4.70107 17.9228 4.23223C17.4539 3.76339 16.818 3.5 16.155 3.5Z" stroke="url(#paint0_linear_972_28532)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
<defs>
<linearGradient id="paint0_linear_972_28532" x1="12" y1="9.6875" x2="12" y2="23.75" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`,
'streamline-plump:customer-support-3-solid':`<svg width="20" height="21" viewBox="0 0 20 21" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M1.04199 9.91667C1.04199 5.03042 5.08366 1.125 10.0003 1.125C14.917 1.125 18.9587 5.03042 18.9587 9.91667V13.4533C18.9587 13.5297 18.9549 13.6051 18.9474 13.6796C18.9549 13.7296 18.9587 13.7808 18.9587 13.8333C18.9587 14.6542 18.8574 15.5487 18.7587 16.2321C18.6037 17.3017 17.9707 18.3625 16.812 18.8212C15.5649 19.3154 13.3995 19.875 10.0003 19.875C9.72406 19.875 9.45911 19.7653 9.26376 19.5699C9.06841 19.3746 8.95866 19.1096 8.95866 18.8333C8.95866 18.5571 9.06841 18.2921 9.26376 18.0968C9.45911 17.9014 9.72406 17.7917 10.0003 17.7917C13.1682 17.7917 15.0691 17.2708 16.0449 16.8846C16.3624 16.7588 16.6241 16.4358 16.6966 15.9337C16.7057 15.8701 16.7148 15.8054 16.7237 15.7396C16.1378 15.87 15.4612 15.9958 14.7882 16.0663C13.9041 16.1592 13.042 15.6262 12.8807 14.6662C12.7866 14.1079 12.7087 13.3025 12.7087 12.1662C12.7087 11.0308 12.7866 10.2258 12.8807 9.66708C13.042 8.70708 13.9041 8.17417 14.7882 8.26708C15.1432 8.30417 15.4995 8.35667 15.8424 8.41708C15.1641 5.91542 12.8266 4.04167 10.0003 4.04167C7.17408 4.04167 4.83699 5.91542 4.15824 8.41708C4.5078 8.35496 4.8594 8.30493 5.21241 8.26708C6.09658 8.17417 6.95866 8.70708 7.12033 9.66708C7.21408 10.2254 7.29199 11.0308 7.29199 12.1667C7.29199 13.3025 7.21408 14.1075 7.12033 14.6662C6.95866 15.6262 6.09658 16.1592 5.21241 16.0663C4.29658 15.9704 3.37491 15.7725 2.68324 15.5996C1.68324 15.3492 1.04199 14.4425 1.04199 13.4537V9.91667Z" fill="url(#paint0_linear_972_28535)"/>
<defs>
<linearGradient id="paint0_linear_972_28535" x1="10.0003" y1="7.57031" x2="10.0003" y2="22.2187" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`,
'mdi:blog-outline':`<svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M19 5.5V19.5H5V5.5H19ZM21 3.5H3V21.5H21V3.5ZM17 17.5H7V16.5H17V17.5ZM17 15.5H7V14.5H17V15.5ZM17 12.5H7V7.5H17V12.5Z" fill="url(#paint0_linear_972_28537)"/>
<defs>
<linearGradient id="paint0_linear_972_28537" x1="12" y1="9.6875" x2="12" y2="23.75" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`,
'wpf:faq':`<svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_972_28539)">
<path d="M12 0.5C10.4308 0.5 9.23077 1.7 9.23077 3.26923V8.80769C9.23077 10.3769 10.4308 11.5769 12 11.5769H17.5385L21.2308 15.2692V11.5769C22.8 11.5769 24 10.3769 24 8.80769V3.26923C24 1.7 22.8 0.5 21.2308 0.5H12ZM15.8658 3.26923H17.4517L19.0098 8.80769H17.6252L17.2495 7.42308H15.8649L15.5197 8.80769H14.3077L15.8658 3.26923ZM16.6154 4.19231C16.5231 4.56154 16.4197 5.012 16.3265 5.28892L16.068 6.5H17.1637L16.9034 5.288C16.7197 5.012 16.6154 4.56154 16.6154 4.19231ZM2.76923 9.73077C1.2 9.73077 0 10.9308 0 12.5V18.0385C0 19.6077 1.2 20.8077 2.76923 20.8077V24.5L6.46154 20.8077H12C13.5692 20.8077 14.7692 19.6077 14.7692 18.0385V12.5H12C10.2462 12.5 8.856 11.3 8.39446 9.73077H2.76923ZM7.00985 12.4132C8.57908 12.4132 9.31754 13.7055 9.31754 15.1825C9.31754 16.4748 8.87354 17.2945 8.13508 17.6637C8.50431 17.8483 8.94185 17.9462 9.40338 18.0385L9.05815 18.9615C8.412 18.7769 7.74185 18.4889 7.09569 18.2111C7.00338 18.1188 6.84185 18.1252 6.74954 18.1252C5.64185 18.0329 4.61538 17.1154 4.61538 15.2692C4.61538 13.7 5.53292 12.4132 7.00985 12.4132ZM7.00985 13.4231C6.27138 13.4231 5.91323 14.2538 5.91323 15.2692C5.91323 16.3769 6.27138 17.1154 7.00985 17.1154C7.74831 17.1154 8.13415 16.2846 8.13415 15.2692C8.13415 14.2538 7.74831 13.4231 7.00985 13.4231Z" fill="url(#paint0_linear_972_28539)"/>
</g>
<defs>
<linearGradient id="paint0_linear_972_28539" x1="12" y1="8.75" x2="12" y2="27.5" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
<clipPath id="clip0_972_28539">
<rect width="24" height="24" fill="white" transform="translate(0 0.5)"/>
</clipPath>
</defs>
</svg>
`,
'weui:setting-filled':`<svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M14.208 5.33C14.6613 5.47 15.0947 5.65 15.508 5.87L17.341 4.77C17.5321 4.65536 17.7561 4.60786 17.9773 4.63504C18.1985 4.66221 18.4043 4.76251 18.562 4.92L19.58 5.938C19.7375 6.0957 19.8378 6.30149 19.865 6.52271C19.8921 6.74392 19.8446 6.96787 19.73 7.159L18.63 8.992C18.85 9.40533 19.03 9.83867 19.17 10.292L21.243 10.811C21.4592 10.8652 21.6512 10.99 21.7883 11.1658C21.9255 11.3415 22 11.5581 22 11.781V13.219C22 13.4419 21.9255 13.6585 21.7883 13.8342C21.6512 14.01 21.4592 14.1348 21.243 14.189L19.17 14.708C19.03 15.1613 18.85 15.5947 18.63 16.008L19.73 17.841C19.8446 18.0321 19.8921 18.2561 19.865 18.4773C19.8378 18.6985 19.7375 18.9043 19.58 19.062L18.562 20.08C18.4043 20.2375 18.1985 20.3378 17.9773 20.365C17.7561 20.3921 17.5321 20.3446 17.341 20.23L15.508 19.13C15.0947 19.35 14.6613 19.53 14.208 19.67L13.689 21.743C13.6348 21.9592 13.51 22.1512 13.3342 22.2883C13.1585 22.4255 12.9419 22.5 12.719 22.5H11.281C11.0581 22.5 10.8415 22.4255 10.6658 22.2883C10.49 22.1512 10.3652 21.9592 10.311 21.743L9.792 19.67C9.3427 19.5312 8.90744 19.3504 8.492 19.13L6.659 20.23C6.46787 20.3446 6.24392 20.3921 6.02271 20.365C5.80149 20.3378 5.5957 20.2375 5.438 20.08L4.42 19.062C4.26251 18.9043 4.16221 18.6985 4.13504 18.4773C4.10786 18.2561 4.15536 18.0321 4.27 17.841L5.37 16.008C5.14964 15.5926 4.96885 15.1573 4.83 14.708L2.757 14.189C2.54092 14.1349 2.3491 14.0101 2.21196 13.8346C2.07483 13.6591 2.00023 13.4428 2 13.22V11.782C2.00001 11.5591 2.0745 11.3425 2.21166 11.1668C2.34881 10.991 2.54075 10.8662 2.757 10.812L4.83 10.293C4.97 9.83967 5.15 9.40633 5.37 8.993L4.27 7.16C4.15536 6.96887 4.10786 6.74492 4.13504 6.52371C4.16221 6.30249 4.26251 6.0967 4.42 5.939L5.438 4.92C5.5957 4.76251 5.80149 4.66221 6.02271 4.63504C6.24392 4.60786 6.46787 4.65536 6.659 4.77L8.492 5.87C8.90533 5.65 9.33867 5.47 9.792 5.33L10.311 3.257C10.3651 3.04092 10.4899 2.8491 10.6654 2.71196C10.8409 2.57483 11.0572 2.50023 11.28 2.5H12.718C12.9409 2.50001 13.1575 2.5745 13.3332 2.71166C13.509 2.84881 13.6338 3.04075 13.688 3.257L14.208 5.33ZM12 16.5C13.0609 16.5 14.0783 16.0786 14.8284 15.3284C15.5786 14.5783 16 13.5609 16 12.5C16 11.4391 15.5786 10.4217 14.8284 9.67157C14.0783 8.92143 13.0609 8.5 12 8.5C10.9391 8.5 9.92172 8.92143 9.17157 9.67157C8.42143 10.4217 8 11.4391 8 12.5C8 13.5609 8.42143 14.5783 9.17157 15.3284C9.92172 16.0786 10.9391 16.5 12 16.5Z" fill="url(#paint0_linear_972_28542)"/>
<defs>
<linearGradient id="paint0_linear_972_28542" x1="12" y1="9.375" x2="12" y2="25" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`,
'gridicons:chat':`<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M3 12C1.9 12 1 11.1 1 10V5C1 3.9 1.9 3 3 3H11C12.1 3 13 3.9 13 5V10C13 11.1 12.1 12 11 12H9V15L6 12H3ZM21 18C22.1 18 23 17.1 23 16V11C23 9.9 22.1 9 21 9H15V10C15 12.2 13.2 14 11 14V16C11 17.1 11.9 18 13 18H15V21L18 18H21Z" fill="url(#paint0_linear_1004_2286)"/>
<defs>
<linearGradient id="paint0_linear_1004_2286" x1="12" y1="6" x2="12" y2="27.6" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`,
'lucide:mouse-pointer-click':`<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M12.4797 10.512C12.8601 10.4671 13.2463 10.5202 13.6018 10.6672H13.6027L30.1027 17.4172L30.1047 17.4182C30.5449 17.5989 30.9167 17.9144 31.1662 18.3196C31.4158 18.725 31.5303 19.1994 31.4934 19.6741C31.4563 20.1488 31.2696 20.6003 30.9602 20.9622C30.6508 21.3238 30.2347 21.5785 29.7717 21.6887L29.7707 21.6877L23.2492 23.2493L21.6896 29.7727L21.6887 29.7717C21.5789 30.2345 21.326 30.6505 20.965 30.9602C20.6027 31.2711 20.151 31.4593 19.675 31.4963C19.199 31.5334 18.7237 31.4172 18.3176 31.1663C17.9125 30.9159 17.5971 30.5437 17.4172 30.1028L10.6672 13.6028V13.6018C10.4988 13.1948 10.4533 12.7474 10.5373 12.3147L10.5754 12.1516C10.678 11.7754 10.8774 11.4316 11.1545 11.1545L11.2766 11.0403C11.572 10.7858 11.93 10.6121 12.3146 10.5374L12.4797 10.512ZM20.1936 28.967L20.1955 28.97C20.1944 28.9673 20.1927 28.9648 20.1916 28.9622L20.1936 28.967ZM19.3117 26.8127L20.3312 22.5501L20.3322 22.5491C20.4616 22.0108 20.7374 21.5185 21.1291 21.1272C21.5207 20.7361 22.0127 20.46 22.551 20.3313L26.8107 19.3108L14.1193 14.1194L19.3117 26.8127ZM6.4123 15.467C6.98288 14.8664 7.93278 14.8418 8.53339 15.4124C9.13396 15.9829 9.15767 16.9329 8.5871 17.5335L5.73749 20.5335C5.1669 21.1339 4.21696 21.1577 3.6164 20.5872C3.01622 20.0165 2.99225 19.0675 3.56269 18.467L6.4123 15.467ZM0.353706 8.90162C0.573963 8.10319 1.39999 7.6338 2.19843 7.85377L6.54902 9.05396C7.34749 9.27428 7.81604 10.1002 7.59589 10.8987C7.37559 11.6973 6.54976 12.1659 5.75117 11.9456L1.40156 10.7463C0.603126 10.5261 0.133736 9.70006 0.353706 8.90162ZM18.467 3.56275C19.0674 2.99231 20.0165 3.01628 20.5871 3.61646C21.1576 4.21702 21.1339 5.16696 20.5334 5.73756L17.5334 8.58716C16.9328 9.15773 15.9829 9.13402 15.4123 8.53345C14.8417 7.93284 14.8664 6.98294 15.467 6.41236L18.467 3.56275ZM8.90156 0.353766C9.7 0.133798 10.526 0.603188 10.7463 1.40162L11.9455 5.75123C12.1658 6.54983 11.6972 7.37565 10.8986 7.59595C10.1001 7.8161 9.27422 7.34755 9.0539 6.54908L7.85371 2.19849C7.63374 1.40005 8.10313 0.574023 8.90156 0.353766Z" fill="url(#paint0_linear_1009_14624)"/>
<defs>
<linearGradient id="paint0_linear_1009_14624" x1="15.9002" y1="26.7124" x2="15.9002" y2="1.80006" gradientUnits="userSpaceOnUse">
<stop stop-color="#806FAF"/>
<stop offset="1" stop-color="white"/>
</linearGradient>
</defs>
</svg>
`,
'papara':`<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.9961 0.857422C15.645 0.857488 18.6035 3.81594 18.6035 7.46484V11.0488C18.6033 14.5836 15.8268 17.4696 12.3359 17.6465L11.9961 17.6553C10.6646 17.6553 9.4261 17.2596 8.38867 16.582V21.8574C8.38863 22.6858 7.71702 23.3574 6.88867 23.3574C6.06027 23.3574 5.38871 22.6858 5.38867 21.8574V7.46484C5.38867 3.93007 8.16453 1.04337 11.6553 0.866211L11.9961 0.857422ZM11.9961 3.85742C10.004 3.85742 8.38867 5.47275 8.38867 7.46484V11.0488C8.38889 13.0407 10.0041 14.6553 11.9961 14.6553L12.1816 14.6504C14.0873 14.5538 15.6033 12.9785 15.6035 11.0488V7.46484C15.6035 5.535 14.0875 3.9589 12.1816 3.8623L11.9961 3.85742Z" fill="white"/>
</svg>
`,
'mdi:bank-outline':`<svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.58337 11.6667H5.25004V19.8334H7.58337V11.6667ZM14.5834 11.6667H12.25V19.8334H14.5834V11.6667ZM24.5 22.1667H2.33337V24.5001H24.5V22.1667ZM21.5834 11.6667H19.25V19.8334H21.5834V11.6667ZM13.4167 3.80341L19.495 7.00008H7.33837L13.4167 3.80341ZM13.4167 1.16675L2.33337 7.00008V9.33341H24.5V7.00008L13.4167 1.16675Z" fill="white"/>
</svg>
`,
'token-branded:usdt':`<svg width="31" height="31" viewBox="0 0 31 31" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M16 26.2001L3.25 13.62L8.11342 5.80005H23.8866L28.75 13.62L16 26.2001ZM17.275 14.725V13.1695C19.57 13.2829 21.712 13.7305 22.375 14.31C21.6043 14.9857 18.8432 15.4773 16 15.4773C13.1567 15.4773 10.3957 14.9857 9.625 14.31C10.2809 13.7291 12.43 13.29 14.725 13.1625V14.725H17.275ZM9.625 14.3043V15.2407C10.2809 15.8215 12.4229 16.2607 14.725 16.3882V19.8251H17.275V16.3826C19.57 16.2678 21.7177 15.8215 22.375 15.2407V13.3735C21.7177 12.7927 19.57 12.3465 17.275 12.226V10.9H21.1V8.98755H10.9V10.9H14.725V12.226C12.4229 12.3465 10.2809 12.7927 9.625 13.3735V14.3043Z" fill="white"/>
</svg>
`,
'mdi:fire':`<svg width="38" height="38" viewBox="0 0 38 38" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M27.9619 17.7333C27.5977 17.2583 27.1544 16.8467 26.7427 16.435C25.6819 15.485 24.4785 14.8042 23.4652 13.8067C21.106 11.495 20.5835 7.67917 22.0877 4.75C20.5835 5.11417 19.2694 5.9375 18.1452 6.84C14.0444 10.1333 12.4294 15.9442 14.361 20.9317C14.4244 21.09 14.4877 21.2483 14.4877 21.4542C14.4877 21.8025 14.2502 22.1192 13.9335 22.2458C13.5694 22.4042 13.1894 22.3092 12.8885 22.0558C12.7987 21.9806 12.7235 21.8893 12.6669 21.7867C10.8777 19.5225 10.5927 16.2767 11.796 13.68C9.15187 15.8333 7.71103 19.475 7.91687 22.9108C8.01187 23.7025 8.10687 24.4942 8.37603 25.2858C8.5977 26.2358 9.0252 27.1858 9.5002 28.025C11.2102 30.7642 14.171 32.7275 17.3535 33.1233C20.7419 33.5508 24.3677 32.9333 26.9644 30.59C29.8619 27.9617 30.8752 23.75 29.3869 20.14L29.181 19.7283C28.8485 19 27.9619 17.7333 27.9619 17.7333ZM22.9585 27.7083C22.5152 28.0883 21.7869 28.5 21.2169 28.6583C19.4435 29.2917 17.6702 28.405 16.6252 27.36C18.5094 26.9167 19.6335 25.5233 19.966 24.1142C20.2352 22.8475 19.7285 21.8025 19.5227 20.5833C19.3327 19.4117 19.3644 18.4142 19.7919 17.3217C20.0927 17.9233 20.4094 18.525 20.7894 19C22.0085 20.5833 23.9244 21.28 24.336 23.4333C24.3994 23.655 24.431 23.8767 24.431 24.1142C24.4785 25.4125 23.9085 26.8375 22.9585 27.7083Z" fill="url(#paint0_linear_670_59680)"/>
<defs>
<linearGradient id="paint0_linear_670_59680" x1="18.9828" y1="14.5466" x2="18.9828" y2="36.8116" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`,
'icon-park-outline:list':`<svg xmlns="http://www.w3.org/2000/svg" width="32" height="33" viewBox="0 0 32 33" fill="none">
  <path d="M3.33301 7.16669L5.33301 9.16669L9.33301 5.16669M3.33301 16.5L5.33301 18.5L9.33301 14.5M3.33301 25.8334L5.33301 27.8334L9.33301 23.8334M13.9997 16.5H28.6663M13.9997 25.8334H28.6663M13.9997 7.16669H28.6663" stroke="url(#paint0_linear_670_59703)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/>
  <defs>
    <linearGradient id="paint0_linear_670_59703" x1="15.9997" y1="12.9584" x2="15.9997" y2="30.6667" gradientUnits="userSpaceOnUse">
      <stop stop-color="#B5A9FF"/>
      <stop offset="1" stop-color="#36246A"/>
    </linearGradient>
  </defs>
</svg>`,
'si:money-fill':`<svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_905_14610)">
<path fill-rule="evenodd" clip-rule="evenodd" d="M5 8.5V10H3.5C2.90326 10 2.33097 10.2371 1.90901 10.659C1.48705 11.081 1.25 11.6533 1.25 12.25V22.75C1.25 23.3467 1.48705 23.919 1.90901 24.341C2.33097 24.7629 2.90326 25 3.5 25H24C24.2955 25 24.5881 24.9418 24.861 24.8287C25.134 24.7157 25.3821 24.5499 25.591 24.341C25.7999 24.1321 25.9657 23.884 26.0787 23.611C26.1918 23.3381 26.25 23.0455 26.25 22.75V21.25H27.75C28.99 21.25 30 20.24 30 19V8.5C30 7.26 28.99 6.25 27.75 6.25H7.25C6.01 6.25 5 7.26 5 8.5ZM7.5 8.75V10H24C24.2955 10 24.5881 10.0582 24.861 10.1713C25.134 10.2843 25.3821 10.4501 25.591 10.659C25.7999 10.8679 25.9657 11.116 26.0787 11.389C26.1918 11.6619 26.25 11.9545 26.25 12.25V18.75H27.5V8.75H7.5ZM11.25 17.5C11.25 16.837 11.5134 16.2011 11.9822 15.7322C12.4511 15.2634 13.087 15 13.75 15C14.413 15 15.0489 15.2634 15.5178 15.7322C15.9866 16.2011 16.25 16.837 16.25 17.5C16.25 18.163 15.9866 18.7989 15.5178 19.2678C15.0489 19.7366 14.413 20 13.75 20C13.087 20 12.4511 19.7366 11.9822 19.2678C11.5134 18.7989 11.25 18.163 11.25 17.5Z" fill="url(#paint0_linear_905_14610)"/>
</g>
<defs>
<linearGradient id="paint0_linear_905_14610" x1="15.625" y1="12.6953" x2="15.625" y2="27.3437" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
<clipPath id="clip0_905_14610">
<rect width="30" height="30" fill="white"/>
</clipPath>
</defs>
</svg>
`,
'mdi:crown':`<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.66667 21.3333L4 6.66665L11.3333 13.3333L16 5.33331L20.6667 13.3333L28 6.66665L25.3333 21.3333H6.66667ZM25.3333 25.3333C25.3333 26.1333 24.8 26.6666 24 26.6666H8C7.2 26.6666 6.66667 26.1333 6.66667 25.3333V24H25.3333V25.3333Z" fill="url(#paint0_linear_670_59718)"/>
<defs>
<linearGradient id="paint0_linear_670_59718" x1="16" y1="12.6666" x2="16" y2="29.3333" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`,
'ep:data-line':`<svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.224 24H5C4.73478 24 4.48043 23.8946 4.29289 23.7071C4.10536 23.5196 4 23.2652 4 23V6H2C1.73478 6 1.48043 5.89464 1.29289 5.70711C1.10536 5.51957 1 5.26522 1 5C1 4.73478 1.10536 4.48043 1.29289 4.29289C1.48043 4.10536 1.73478 4 2 4H30C30.2652 4 30.5196 4.10536 30.7071 4.29289C30.8946 4.48043 31 4.73478 31 5C31 5.26522 30.8946 5.51957 30.7071 5.70711C30.5196 5.89464 30.2652 6 30 6H28V23C28 23.2652 27.8946 23.5196 27.7071 23.7071C27.5196 23.8946 27.2652 24 27 24H20.788L24.252 30H21.944L18.48 24H13.532L10.068 30H7.76L11.224 24ZM26 6H6V22H26V6ZM10.708 16.708C10.615 16.801 10.5046 16.8747 10.3832 16.925C10.2617 16.9754 10.1315 17.0013 10 17.0013C9.86851 17.0013 9.73831 16.9754 9.61683 16.925C9.49535 16.8747 9.38498 16.801 9.292 16.708C9.19902 16.615 9.12527 16.5046 9.07495 16.3832C9.02464 16.2617 8.99874 16.1315 8.99874 16C8.99874 15.8685 9.02464 15.7383 9.07495 15.6168C9.12527 15.4954 9.19902 15.385 9.292 15.292L13.906 10.68L17.826 13.62L21.22 9.376C21.2994 9.26649 21.4003 9.17423 21.5164 9.10482C21.6325 9.03541 21.7615 8.99028 21.8956 8.97217C22.0297 8.95406 22.166 8.96335 22.2964 8.99947C22.4268 9.03559 22.5485 9.09779 22.6542 9.18231C22.7598 9.26682 22.8472 9.3719 22.9111 9.49117C22.9749 9.61044 23.0139 9.74144 23.0257 9.87622C23.0374 10.011 23.0217 10.1468 22.9795 10.2753C22.9373 10.4038 22.8694 10.5225 22.78 10.624L18.176 16.382L14.094 13.32L10.708 16.706V16.708Z" fill="url(#paint0_linear_670_59739)"/>
<defs>
<linearGradient id="paint0_linear_670_59739" x1="16" y1="12.9375" x2="16" y2="33.25" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`,
'mdi:user':`<svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M15 5C16.3261 5 17.5979 5.52678 18.5355 6.46447C19.4732 7.40215 20 8.67392 20 10C20 11.3261 19.4732 12.5979 18.5355 13.5355C17.5979 14.4732 16.3261 15 15 15C13.6739 15 12.4021 14.4732 11.4645 13.5355C10.5268 12.5979 10 11.3261 10 10C10 8.67392 10.5268 7.40215 11.4645 6.46447C12.4021 5.52678 13.6739 5 15 5ZM15 17.5C20.525 17.5 25 19.7375 25 22.5V25H5V22.5C5 19.7375 9.475 17.5 15 17.5Z" fill="url(#paint0_linear_844_66578)"/>
<defs>
<linearGradient id="paint0_linear_844_66578" x1="15" y1="11.875" x2="15" y2="27.5" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`,
'':`<svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_890_14615)">
<path fill-rule="evenodd" clip-rule="evenodd" d="M5 8.5V10H3.5C2.90326 10 2.33097 10.2371 1.90901 10.659C1.48705 11.081 1.25 11.6533 1.25 12.25V22.75C1.25 23.3467 1.48705 23.919 1.90901 24.341C2.33097 24.7629 2.90326 25 3.5 25H24C24.2955 25 24.5881 24.9418 24.861 24.8287C25.134 24.7157 25.3821 24.5499 25.591 24.341C25.7999 24.1321 25.9657 23.884 26.0787 23.611C26.1918 23.3381 26.25 23.0455 26.25 22.75V21.25H27.75C28.99 21.25 30 20.24 30 19V8.5C30 7.26 28.99 6.25 27.75 6.25H7.25C6.01 6.25 5 7.26 5 8.5ZM7.5 8.75V10H24C24.2955 10 24.5881 10.0582 24.861 10.1713C25.134 10.2843 25.3821 10.4501 25.591 10.659C25.7999 10.8679 25.9657 11.116 26.0787 11.389C26.1918 11.6619 26.25 11.9545 26.25 12.25V18.75H27.5V8.75H7.5ZM11.25 17.5C11.25 16.837 11.5134 16.2011 11.9822 15.7322C12.4511 15.2634 13.087 15 13.75 15C14.413 15 15.0489 15.2634 15.5178 15.7322C15.9866 16.2011 16.25 16.837 16.25 17.5C16.25 18.163 15.9866 18.7989 15.5178 19.2678C15.0489 19.7366 14.413 20 13.75 20C13.087 20 12.4511 19.7366 11.9822 19.2678C11.5134 18.7989 11.25 18.163 11.25 17.5Z" fill="url(#paint0_linear_890_14615)"/>
</g>
<defs>
<linearGradient id="paint0_linear_890_14615" x1="15.625" y1="12.6953" x2="15.625" y2="27.3437" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
<clipPath id="clip0_890_14615">
<rect width="30" height="30" fill="white"/>
</clipPath>
</defs>
</svg>
`,
'ph:star-four-fill':`<svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M28.1249 15C28.1279 15.3845 28.011 15.7604 27.7904 16.0755C27.5699 16.3905 27.2567 16.629 26.8944 16.7578L19.46 19.4613L16.7577 26.8945C16.6245 27.2534 16.3847 27.5628 16.0704 27.7814C15.7562 27.9999 15.3826 28.1171 14.9999 28.1171C14.6171 28.1171 14.2435 27.9999 13.9293 27.7814C13.6151 27.5628 13.3753 27.2534 13.2421 26.8945L10.5397 19.4601L3.10534 16.7578C2.74651 16.6246 2.43703 16.3848 2.21849 16.0706C1.99995 15.7563 1.88281 15.3827 1.88281 15C1.88281 14.6172 1.99995 14.2437 2.21849 13.9294C2.43703 13.6152 2.74651 13.3754 3.10534 13.2422L10.5397 10.5398L13.2421 3.10546C13.3753 2.74663 13.6151 2.43716 13.9293 2.21861C14.2435 2.00007 14.6171 1.88293 14.9999 1.88293C15.3826 1.88293 15.7562 2.00007 16.0704 2.21861C16.3847 2.43716 16.6245 2.74663 16.7577 3.10546L19.4612 10.5398L26.8944 13.2422C27.2567 13.371 27.5699 13.6095 27.7904 13.9245C28.011 14.2396 28.1279 14.6155 28.1249 15Z" fill="url(#paint0_linear_890_14619)"/>
<defs>
<linearGradient id="paint0_linear_890_14619" x1="15.0039" y1="10.9009" x2="15.0039" y2="31.3963" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`,
'star_ico':`<svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.08398 0L9.99235 5.87336L16.168 5.87336L11.1718 9.50329L13.0802 15.3766L8.08398 11.7467L3.08781 15.3766L4.99618 9.50329L3.8147e-06 5.87336L6.17562 5.87336L8.08398 0Z" fill="url(#paint0_linear_670_67415)"/>
<defs>
<linearGradient id="paint0_linear_670_67415" x1="8.08398" y1="5.84375" x2="8.08398" y2="19.125" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`,
'mdi:marker-tick':`<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M10 16L5 11L6.41 9.58L10 13.17L17.59 5.58L19 7M19 1H5C3.89 1 3 1.89 3 3V15.93C3 16.62 3.35 17.23 3.88 17.59L12 23L20.11 17.59C20.64 17.23 21 16.62 21 15.93V3C21 2.46957 20.7893 1.96086 20.4142 1.58579C20.0391 1.21071 19.5304 1 19 1Z" fill="url(#paint0_linear_670_63840)"/>
<defs>
<linearGradient id="paint0_linear_670_63840" x1="12" y1="8.5625" x2="12" y2="25.75" gradientUnits="userSpaceOnUse">
<stop stop-color="#B5A9FF"/>
<stop offset="1" stop-color="#36246A"/>
</linearGradient>
</defs>
</svg>
`
} as const

// Tüm icon setlerini birleştiren ana obje
export const iconData = {
  ...solarIcons
} as const

// Type güvenliği için icon adlarını export et
export type IconName = keyof typeof iconData