export interface BlogPost {
  id: string
  title: string
  slug: string
  excerpt: string
  content: string
  featuredImage?: string
  images?: string[]
  author: BlogAuthor
  category: BlogCategory
  tags: string[]
  status: BlogStatus
  isPublished: boolean
  publishedAt?: string
  createdAt: string
  updatedAt: string
  views: number
  likes: number
  comments: BlogComment[]
  estimatedReadTime: number // dakika cinsinden
  seoTitle?: string
  seoDescription?: string
  seoKeywords?: string[]
}

export interface BlogAuthor {
  id: string
  name: string
  avatar?: string
  bio?: string
  social?: {
    twitter?: string
    linkedin?: string
    website?: string
  }
}

export interface BlogCategory {
  id: string
  name: string
  slug: string
  description?: string
  color?: string
  icon?: string
  postCount: number
}

export type BlogStatus = 'draft' | 'published' | 'archived'

export interface BlogComment {
  id: string
  postId: string
  author: {
    id: string
    name: string
    avatar?: string
  }
  content: string
  parentId?: string // reply için
  likes: number
  isApproved: boolean
  createdAt: string
  updatedAt: string
  replies?: BlogComment[]
}

export interface BlogFilter {
  category?: string[]
  tags?: string[]
  author?: string
  dateRange?: {
    start: string
    end: string
  }
  status?: BlogStatus[]
  search?: string
  sortBy?: 'created_at' | 'published_at' | 'views' | 'likes' | 'title'
  sortOrder?: 'asc' | 'desc'
}

export interface CreateBlogPost {
  title: string
  excerpt: string
  content: string
  featuredImage?: File
  categoryId: string
  tags: string[]
  status: BlogStatus
  publishedAt?: string
  seoTitle?: string
  seoDescription?: string
  seoKeywords?: string[]
}

export interface UpdateBlogPost extends Partial<CreateBlogPost> {
  id: string
}

export interface BlogStats {
  totalPosts: number
  publishedPosts: number
  draftPosts: number
  totalViews: number
  totalLikes: number
  totalComments: number
  popularPosts: BlogPost[]
  recentPosts: BlogPost[]
  topCategories: (BlogCategory & { postCount: number })[]
}

export interface RelatedPost {
  id: string
  title: string
  slug: string
  excerpt: string
  featuredImage?: string
  publishedAt: string
  estimatedReadTime: number
  category: BlogCategory
}